<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreOfferRequest;
use App\Models\Package;
use App\Models\PackageVideo;
use App\Models\PackageVideoOffers;
use App\Models\PackageVideoSubscriptions;
use App\Models\PackageVideoVideo;
use App\Models\Videos;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use newrelic\DistributedTracePayload;
use Validator;

class PackageVideoController extends Controller
{

    public function index(Request $request)
    {

        $sort_search = null;
        $packages = PackageVideo::orderBy('created_at', 'desc');
        if ($request->has('search')) {
            $sort_search = $request->search;
            $packages = $packages->where('name_' . App::getLocale(), 'like', '%' . $sort_search . '%');
        }
        $packages = $packages->paginate(20);
        return view('admin.package_video.index', compact('packages', 'sort_search'));
    }

    public function create()
    {
        $videos = Videos::pluck('name_' . App::getLocale(), 'id');
        return view('admin.package_video.create', compact('videos'));
    }

    public function store(Request $request)
    {

        $request->validate([
            'name_ar' => 'required',
            'notes_ar' => 'required',
            'price' => 'required',
            'videos'=>'required',
            'videos.*'=>'required',
            'expiration_duration_in_dayes' => 'required',
            'count_play_video' => 'required',
            'show_one_video' => 'required',
            "photo_phone"=> "required|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "photo_desktop"=> "required|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_desktop_nl"=> "required_if:type_view,photo|nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_desktop_en"=> "required_if:type_view,photo|nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_desktop_ar"=> "required_if:type_view,photo|nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_phone_ar"=> "required_if:type_view,photo|nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_phone_nl"=> "required_if:type_view,photo|nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_phone_en"=> "required_if:type_view,photo|nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
        ]);
        $package = new PackageVideo();
        if($request->file('photo_desktop'))
        {
            $nameDesk =   saveFile($request->file('photo_desktop'), 'package');
            $package->photo_desktop = $nameDesk;
        }
        if($request->file('photo_phone'))
        {
            $namePhone = saveFile($request->file('photo_phone'), 'package');
            $package->photo_phone = $namePhone;
        }
        if($request->file('cove_phone_en'))
        {
            $namePhone = saveFile($request->file('cove_phone_en'), 'package');
            $package->cove_phone_en = $namePhone;
        }
        if($request->file('cove_phone_nl'))
        {
            $namePhone = saveFile($request->file('cove_phone_nl'), 'package');
            $package->cove_phone_nl = $namePhone;
        }
        if($request->file('cove_phone_ar'))
        {
            $namePhone = saveFile($request->file('cove_phone_ar'), 'package');
            $package->cove_phone_ar = $namePhone;
        }
        if($request->file('cove_desktop_nl'))
        {
            $namePhone = saveFile($request->file('cove_desktop_nl'), 'package');
            $package->cove_desktop_nl = $namePhone;
        }
        if($request->file('cove_desktop_en'))
        {
            $namePhone = saveFile($request->file('cove_desktop_en'), 'package');
            $package->cove_desktop_en = $namePhone;
        }
        if($request->file('cove_desktop_ar'))
        {
            $namePhone = saveFile($request->file('cove_desktop_ar'), 'package');
            $package->cove_desktop_ar = $namePhone;
        }

        $package->type_view = $request->type_view;
        $package->name_ar = $request->name_ar;
        $package->name_en = $request->name_en;
        $package->name_nl = $request->name_nl;
        $package->notes_ar = $request->notes_ar;
        $package->notes_en = $request->notes_en;
        $package->notes_nl = $request->notes_nl;
        $package->price = $request->price;
        $package->expiration_duration_in_dayes = $request->expiration_duration_in_dayes;
        $package->count_play_video = $request->count_play_video;
        $package->show_one_video = $request->show_one_video;
        $package->badge_ar = $request->badge_ar;
        $package->badge_en = $request->badge_en;
        $package->badge_nl = $request->badge_nl;
        $package->arrangement = $request->arrangement;
        $package->color_background = $request->color_background;
        $package->color_border = $request->color_border;
        $package->active = ($request->active == 'on') ? true : false;
        $package->show_in_home = ($request->show_in_home == 'on') ? true : false;
        $package->save();
        $package->video()->sync($request->videos);
        $package->video_count = sizeof($request->videos);
        $package->save();
        session()->flash('notif', trans('messages.add_successfully'));
        return redirect()->route('package_video.index');
    }

    public function edit(PackageVideo $package)
    {

        $videos = Videos::pluck('name_' . App::getLocale(), 'id');
        return view('admin.package_video.edit', compact('package', 'videos'));
    }

    public function update(Request $request, PackageVideo $package)
    {
        $request->validate([
            'name_ar' => 'required',
            'notes_ar' => 'required',
            'price' => 'required',
            'videos'=>'required',
            'videos.*'=>'required',
            'expiration_duration_in_dayes' => 'required',
            'count_play_video' => 'required',
            'show_one_video' => 'required',
            "photo_phone"=> "nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "photo_desktop"=> "nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_desktop_nl"=> "nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_desktop_en"=> "nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_desktop_ar"=> "nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_phone_ar"=> "nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_phone_nl"=> "nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
            "cove_phone_en"=> "nullable|mimetypes:image/jpeg,image/png,image/jpg,image/gif,video/mp4,video/x-matroska,video/avi|max:5000",
        ]);

        if($request->file('photo_desktop'))
        {
            $nameDesk =   saveFile($request->file('photo_desktop'), 'package');
            $package->photo_desktop = $nameDesk;
        }
        if($request->file('photo_phone'))
        {
            $namePhone = saveFile($request->file('photo_phone'), 'package');
            $package->photo_phone = $namePhone;
        }
        if($request->file('cove_phone_en'))
        {
            $namePhone = saveFile($request->file('cove_phone_en'), 'package');
            $package->cove_phone_en = $namePhone;
        }
        if($request->file('cove_phone_nl'))
        {
            $namePhone = saveFile($request->file('cove_phone_nl'), 'package');
            $package->cove_phone_nl = $namePhone;
        }
        if($request->file('cove_phone_ar'))
        {
            $namePhone = saveFile($request->file('cove_phone_ar'), 'package');
            $package->cove_phone_ar = $namePhone;
        }
        if($request->file('cove_desktop_nl'))
        {
            $namePhone = saveFile($request->file('cove_desktop_nl'), 'package');
            $package->cove_desktop_nl = $namePhone;
        }
        if($request->file('cove_desktop_en'))
        {
            $namePhone = saveFile($request->file('cove_desktop_en'), 'package');
            $package->cove_desktop_en = $namePhone;
        }
        if($request->file('cove_desktop_ar'))
        {
            $namePhone = saveFile($request->file('cove_desktop_ar'), 'package');
            $package->cove_desktop_ar = $namePhone;
        }
        $package->type_view = $request->type_view;
        $package->name_ar = $request->name_ar;
        $package->name_en = $request->name_en;
        $package->name_nl = $request->name_nl;
        $package->notes_ar = $request->notes_ar;
        $package->notes_en = $request->notes_en;
        $package->notes_nl = $request->notes_nl;
        $package->price = $request->price;
        $package->expiration_duration_in_dayes = $request->expiration_duration_in_dayes;
        $package->count_play_video = $request->count_play_video;
        $package->show_one_video = $request->show_one_video;
        $package->badge_ar = $request->badge_ar;
        $package->badge_en = $request->badge_en;
        $package->badge_nl = $request->badge_nl;
        $package->arrangement = $request->arrangement;
        $package->show_in_home = ($request->show_in_home == 'on') ? true : false;
        $package->active = ($request->active == 'on') ? true : false;
        $package->video_count = PackageVideoVideo::where('package_id', $package->id)->count();
        $package->color_background = $request->color_background;
        $package->color_border = $request->color_border;
        $package->save();
        $package->video()->sync($request->videos);
        $package->video_count = sizeof($request->videos);
        $package->save();
        session()->flash('notif', trans('messages.updated_successfully'));
        return redirect()->route('package_video.index');
    }

    public function changeActive(Request $request)
    {
        $package = PackageVideo::find($request->id);
        if(!empty($package))
        {
            $package->active =  $package->active == 1 ?0:1;
            return $package->save();
        }
        return false;
    }

    public function destroy(PackageVideo $package)
    {
        $package->delete();
        session()->flash('notif', trans('messages.Package deleted successfully'));
        return redirect()->route('package_video.index');
    }

    // craeted offer or updated
    public function cerateEditOffer(Request $request)
    {
        $package = PackageVideo::find($request->id);
        if ($package->offer) {
            return view('admin.package_video.Offer.edit', compact('package'));
        } else {
            return view('admin.package_video.Offer.create', compact('package'));
        }
    }
    // created offer

    public function CreatedOffers(Request $request)
    {
        $rules = [
            'title_ar' => 'required',
            'package_id' => 'required',
            'start_date' => 'required',
            'end_date' => 'required',
            'discount_amount' => 'required'
        ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            session()->flash('notif', trans('messages.NOt Save'));
            return redirect()->back()->withErrors($validator->errors())->withInput($request->all());
        }

        $offer = new PackageVideoOffers();
        $offer->title_ar = $request->title_ar;
        $offer->title_en = $request->title_en;
        $offer->title_nl = $request->title_nl;
        $offer->package_id  = $request->package_id;
        $offer->start_date = $request->start_date;
        $offer->end_date = $request->end_date;
        $offer->discount_amount = $request->discount_amount;
        $offer->save();
        session()->flash('notif', trans('messages.add_successfully'));
        return redirect()->route('package_video.index');
    }
    public function updatedOffers(Request $request, PackageVideoOffers $offer)
    {
        $rules = [
            'title_ar' => 'required',
            'package_id' => 'required',
            'start_date' => 'required',
            'end_date' => 'required',
            'discount_amount' => 'required'
        ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            session()->flash('notif', trans('messages.NOt Save'));
            return redirect()->back()->withErrors($validator->errors())->withInput($request->all());
        }
        $offer->title_ar = $request->title_ar;
        $offer->title_en = $request->title_en;
        $offer->title_nl = $request->title_nl;
        $offer->package_id  = $request->package_id;
        $offer->start_date = $request->start_date;
        $offer->end_date = $request->end_date;
        $offer->discount_amount = $request->discount_amount;
        $offer->save();
        session()->flash('notif', trans('messages.updated_successfully'));
        return redirect()->route('package_video.index');
    }

    public function delOffer($id)
    {
        $package = PackageVideo::with('offer')->find($id);
        if($package->offer != null)
        {
            $offer = PackageVideoOffers::find($package->offer->id);
            $offer->delete();
            session()->flash('notif', trans('messages.offer deleted successfully'));
            return redirect()->route('package_video.index');
        }

        return redirect()->route('package_video.index');
    }

    public function showSubscrip($id)
    {
        $package = PackageVideo::find($id);
        if(!empty($package))
        {
            $packageSub = PackageVideoSubscriptions::where('package_id',$id)->orderBy('updated_at', 'desc')->paginate(20);
            return view('admin.package_video.show', compact('packageSub', 'package'));

        }
        session()->flash('notif', trans('messages.NotFound'));
        return redirect()->back();
    }

    public function updatedSubscrib($id)
    {
        $sub = PackageVideoSubscriptions::find($id);
        if(!empty($sub))
        {
            $sub->delete();
            session()->flash('notif', trans('messages.Package deleted successfully'));
            return redirect()->back();
        }
        return redirect()->back();
    }

    public function subscripUpdated($id)
    {
        $sub = PackageVideoSubscriptions::find($id);
        if(!empty($sub))
        {
            return view('admin.package_video.updatedSub', compact('sub'));
        }
        return redirect()->back();
    }

    public function updatedProcessSub(Request $request, $id)
    {
        $sub = PackageVideoSubscriptions::find($id);
        if(!empty($sub))
        {
            $sub->expiration_date = $request->date;
            $sub->count_play = $request->count_play;
            $sub->one_count_play = $request->one_count_play;
            $sub->save();
            session()->flash('notif', trans('messages.updated_successfully'));
            return redirect()->route('package_video.show', $sub->package_id);
        }

        return redirect()->back();
    }




}
