<?php

namespace App\Http\Controllers\Api\General;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\PaymentMethodResource;
use App\Http\Resources\PaymentMethodResourceCollection;
use Mollie\Laravel\Facades\Mollie;

class PaymentControllers extends Controller
{
    use ApiResponse;

    public function getPaymentMethods()
    {

        $methods = Mollie::api()->methods->allActive();
        $paymentMethods = collect($methods);
        $collection = new  PaymentMethodResourceCollection($paymentMethods);
        return $this->apiResponse(200, 'paymentMethods', null, $collection);
    }
}
