<?php

namespace App\Http\Controllers\Api\Packages;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\PackagesCollection;
use App\Models\Package;

class PackagesControllers extends Controller
{
    use ApiResponse;
    public function packages($limit)
    {
        $packages = Package::with('offer')->where('active', 1)->orderBy('arrangement_phone')->paginate($limit);
        $collect = new PackagesCollection($packages);
        return $this->apiResponse(200, 'All Data', null, $collect);
    }
}
