<?php

namespace App\Http\Middleware;

use Illuminate\Http\Request;

use Closure;
use Illuminate\Support\Facades\App;
class ApiLanguageManager
{
    public function handle(Request $request, Closure $next)
    {
        $local = ($request->hasHeader('x-lang')) ? $request->header('x-lang') : 'ar';
        // set laravel localization
        app()->setLocale($local);
        config(['app.fallback_locale' => $local]);
        // continue request
        return $next($request);
    }
}
