<?php

namespace App\Http\Resources;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class PackagesResource extends JsonResource
{

    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'notes' => $this->notes,
            'badge' => $this->badge,
            'type_view' => $this->type_view,
            'photo' => $this->photo,
            'photo_extension' => $this->checkExtions($this->photo),
            'color_background' => $this->color_background,
            'color_border' => $this->color_border,
            'cover_phone' => $this->coverPhone,
            'cover_phone_extension' => $this->checkExtions($this->coverPhone),
            'price' => $this->price,
            'exam_count' => $this->exam_count,
            'offer' => $this->getOfferData()
        ];
    }

    public function checkExtions($pro)
    {
        if ($pro != null) {
            $extension = pathinfo($pro, PATHINFO_EXTENSION);
            $imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
            if (in_array(pathinfo($pro, PATHINFO_EXTENSION), ["jpg", "jpeg", "gif", "png", "bmp", "webp", "PNG", "GIF", "JPG"]))
                return 'photo';

            return 'video';
        }

        return null;

    }

    public function getOfferData()
    {
        if ($this->offer != null) {
            return [
                'id' => $this->offer->id,
                'name' => $this->offer->title,
                'start_date' => Carbon::parse($this->offer->start_date)->format('Y-m-d H:i:s'),
                'end_date' => Carbon::parse($this->offer->end_date)->format('Y-m-d H:i:s'),
                'discount_amount' => $this->discount_amount,
            ];
        }

        return null;
    }
}
