<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PackageVideo extends Model
{
    use softDeletes;
    protected $table = 'package_video';

    public function video()
    {
        return $this->belongsToMany(Videos::class, 'package_video_video', 'package_id', 'video_id');
    }

    public function offer()
    {
        return $this->hasOne(PackageVideoOffers::class, 'package_id')->where('end_date','>',Carbon::now());
    }
}
