@extends('admin.layouts.main')
@section('content')
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title">{{ trans('messages.Add Package') }}</h3>
            </div>

        </div>
    </div>

    <style>
        .bootstrap-tagsinput {
            width: 100%;
            padding: 0.6em;
        }
    </style>
    <!-- Main content -->

    <section class="content">
        {!! Form::open(['route' => 'package.store', 'files' => true, 'id' => 'add-package-form']) !!}
        <div class="row">
            <div class="col-lg-8 mx-auto">

                <div class="box">
                    <div class="box-body">
                        <!-- Nav tabs -->
                        <ul class="nav nav-tabs customtab2" role="tablist">
                            <li class="nav-item"><a class="nav-link active" data-toggle="tab" href="#home7"
                                                    role="tab"><span class="hidden-sm-up"><i
                                            class="ion-home"></i></span> <span
                                        class="hidden-xs-down">{{ trans('messages.Arabic') }}</span></a></li>
                            <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#profile7"
                                                    role="tab"><span class="hidden-sm-up"><i
                                            class="ion-person"></i></span> <span
                                        class="hidden-xs-down">{{ trans('messages.Netherland') }}</span></a></li>
                            <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#home8"
                                                    role="tab"><span class="hidden-sm-up"><i
                                            class="ion-home"></i></span> <span
                                        class="hidden-xs-down">{{ trans('messages.English') }}</span></a></li>
                        </ul>

                        <!-- Tab panes -->
                        <div class="tab-content">
                            <div class="tab-pane active" id="home7" role="tabpanel">
                                <div class="p-15">
                                    <div class="form-group">
                                        <label for="name_ar">{{ trans('messages.Name Ar') }}
                                        </label>
                                        <div>
                                            {!! Form::text('name_ar', null, ['class' => 'form-control', 'placeholder' => trans('messages.Name Ar')]) !!}
                                        </div>
                                        @error('name_ar')
                                        <div class="badge badge-danger text-center" style="width: 100%">
                                            {{ $message }}
                                        </div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="badge_ar">{{ trans('messages.Badge Ar') }}
                                        </label>
                                        <div>
                                            {!! Form::text('badge_ar', null, ['class' => 'form-control', 'placeholder' => trans('messages.Badge Ar')]) !!}
                                        </div>
                                        @error('badge_ar')
                                        <div class="badge badge-danger text-center" style="width: 100%">
                                            {{ $message }}
                                        </div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="notes_ar">{{ trans('messages.Notes Ar') }}
                                        </label>
                                        <div>
                                            {!! Form::textarea('notes_ar', null, [
                                                'id' => 'editor1',
                                                'class' => 'form-control',
                                                'placeholder' => trans('messages.Notes Ar'),
                                            ]) !!}
                                        </div>
                                        @error('notes_ar')
                                        <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                        </div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="home8" role="tabpanel">
                                <div class="p-15">
                                    <div class="form-group">
                                        <label for="name_en">{{ trans('messages.Name EN') }}
                                        </label>
                                        <div>
                                            {!! Form::text('name_en', null, ['class' => 'form-control', 'placeholder' => trans('messages.Name EN')]) !!}
                                        </div>
                                        @error('name_en')
                                        <div class="badge badge-danger text-center" style="width: 100%">
                                            {{ $message }}
                                        </div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="badge_en">{{ trans('messages.Badge EN') }}
                                        </label>
                                        <div>
                                            {!! Form::text('badge_en', null, ['class' => 'form-control', 'placeholder' => trans('messages.Badge EN')]) !!}
                                        </div>
                                        @error('badge_en')
                                        <div class="badge badge-danger text-center" style="width: 100%">
                                            {{ $message }}
                                        </div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="notes_en">{{ trans('messages.Notes EN') }}
                                        </label>
                                        <div>
                                            {!! Form::textarea('notes_en', null, [
                                                'id' => 'editoren',
                                                'class' => 'form-control',
                                                'placeholder' => trans('messages.Notes EN'),
                                            ]) !!}
                                        </div>
                                        @error('notes_en')
                                        <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                        </div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="profile7" role="tabpanel">
                                <div class="p-15">
                                    <div class="form-group">
                                        <label for="name_nl">{{ trans('messages.Name Nl') }}
                                        </label>
                                        <div>
                                            {!! Form::text('name_nl', null, ['class' => 'form-control', 'placeholder' => trans('messages.Name Nl')]) !!}
                                        </div>
                                        @error('name_nl')
                                        <div class="badge badge-danger text-center" style="width: 100%">
                                            {{ $message }}
                                        </div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="badge_nl">{{ trans('messages.Badge Nl') }}
                                        </label>
                                        <div>
                                            {!! Form::text('badge_nl', null, ['class' => 'form-control', 'placeholder' => trans('messages.Badge Nl')]) !!}
                                        </div>
                                        @error('badge_nl')
                                        <div class="badge badge-danger text-center" style="width: 100%">
                                            {{ $message }}
                                        </div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="notes_nl">{{ trans('messages.Notes Nl') }}
                                        </label>
                                        <div>
                                            {!! Form::textarea('notes_nl', null, [
                                                'id' => 'editor2',
                                                'class' => 'form-control',
                                                'placeholder' => trans('messages.Notes Nl'),
                                            ]) !!}
                                        </div>
                                        @error('notes_nl')
                                        <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                        </div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="name">{{ trans('messages.Exams') }}
                            </label>
                            <div>
                                {!! Form::select('exams[]', $exams, null, [
                                    'multiple' => 'multiple',
                                    'class' => 'form-control select2',
                                    'data-placeholder' => trans('messages.Exams'),
                                ]) !!}

                            </div>

                        </div>
                        <div class="form-group">
                            <label for="price">{{ trans('messages.Price') }}
                            </label>
                            <div>
                                {!! Form::number('price', null, ['class' => 'form-control', 'placeholder' => trans('messages.Price')]) !!}
                            </div>
                            @error('price')
                            <div class="badge badge-danger text-center" style="width: 100%">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="expiration_duration_in_dayes">{{ trans('messages.Expiration duration') }}
                            </label>
                            <div>
                                {!! Form::number('expiration_duration_in_dayes', null, [
                                    'class' => 'form-control',
                                    'placeholder' => trans('messages.Expiration duration'),
                                ]) !!}
                            </div>
                            @error('expiration_duration_in_dayes')
                            <div class="badge badge-danger text-center" style="width: 100%">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="arrangement">{{ trans('messages.Arrangement') }}
                            </label>
                            <div>
                                {!! Form::number('arrangement', 0, [
                                    'class' => 'form-control',
                                    'placeholder' => trans('messages.Expiration duration'),
                                ]) !!}
                            </div>
                            @error('arrangement')
                            <div class="badge badge-danger text-center" style="width: 100%">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="arrangement_phone">{{ trans('messages.arrangement_phone') }}
                            </label>
                            <div>
                                {!! Form::number('arrangement_phone', 0, [
                                    'class' => 'form-control',
                                    'placeholder' => trans('messages.arrangement_phone'),
                                ]) !!}
                            </div>
                            @error('arrangement_phone')
                            <div class="badge badge-danger text-center" style="width: 100%">
                                {{ $message }}
                            </div>
                            @enderror
                        </div>
                        <div class="col-lg-12" style="margin-bottom: 5px; background: #8950FC; color: #fff;padding: 5px;">في حاله اختيار طريقة العرض ( نص ) سوف يتم عرض هذه الصور </div>

                        <div class="row" style="margin-bottom: 5px;border-bottom:1px #8950FC solid;border-right:1px #8950FC solid;">
                            <div class="form-group">
                                <div class="col-lg-12 mx-auto">
                                    <div class="custom-file-container_2">
                                        <div class="custom-file_2">
                                            <input type="file" name="photo_phone" class="custom-file-input_phone" id="image">
                                            <label class="custom-file-label"
                                                   for="image">{{ trans('messages.photo_phone') }}</label>
                                        </div>
                                        <div class="bg-lightest p-10 rounded5 dvPreview text-center custom-file-input_phone_preview"
                                             style="width: 100%;margin-top: 1em;height: 10em;">
                                            <img style="max-width: 100%;height: 100%;"
                                                 src="{{ url('/images/noimg.png') }}"
                                                 alt="">
                                            <video style="max-width: 100%;height: 100%;display: none;" controls autoplay>

                                            </video>
                                        </div>
                                    </div>
                                    @error('photo_phone')
                                    <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-lg-12 mx-auto">
                                    <div class="custom-file-container_2">
                                        <div class="custom-file_2">
                                            <input type="file" name="photo_desktop" class="custom-file-input_2"
                                                   id="image_2">
                                            <label class="custom-file-label"
                                                   for="image_2">{{ trans('messages.photo_desktop') }}</label>
                                        </div>
                                        <div class="bg-lightest p-10 rounded5 dvPreview text-center custem-css-templet_2"
                                            style="width: 100%;margin-top: 1em;height: 10em;">
                                            <img style="max-width: 100%;height: 100%;"
                                                 src="{{ url('/images/noimg.png') }}"
                                                 alt="">
                                            <video style="max-width: 100%;height: 100%;display: none;" controls autoplay>

                                            </video>
                                        </div>
                                    </div>
                                    @error('photo_desktop')
                                    <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-xl-6">
                                <div class="form-group">
                                    <label for="arrangement">{{ trans('messages.color_background') }}
                                    </label>
                                    <div>
                                        {!! Form::color('color_background', null, [
                                             'class' => 'form-control',
                                         ]) !!}
                                    </div>
                                    @error('color_background')
                                    <div class="badge badge-danger text-center" style="width: 100%">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="form-group">
                                    <label for="arrangement">{{ trans('messages.color_border') }}
                                    </label>
                                    <div>
                                        {!! Form::color('color_border', null, [
                                             'class' => 'form-control',
                                         ]) !!}
                                    </div>
                                    @error('color_border')
                                    <div class="badge badge-danger text-center" style="width: 100%">
                                        {{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="checkbox">
                                {!! Form::checkbox('show_in_home', null, 1, ['id' => 'show_in_home']) !!}
                                <label for="show_in_home">{{ trans('messages.Show in home') }}</label>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="checkbox">
                                {!! Form::checkbox('enable', null, 1, ['id' => 'Checkbox_1']) !!}
                                <label for="Checkbox_1">{{ trans('messages.Enabled') }}</label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="label-default" for="type_view">{{__('messages.type_view')}}:</label>
                        <select class="form-control select2-container" name="type_view" id="type_view">
                            <option value="text" {{old('type_view')!=null && old('type_view') == 'text'?'selected':''}}>{{__('messages.choseText')}}</option>
                            <option value="photo" {{old('type_view')!=null && old('type_view') == 'photo'?'selected':''}}>{{__('messages.chosephoto')}}</option>
                        </select>
                    </div>

                    <div class="row">
                        <div class="form-group">
                            <div class="col-lg-12 mx-auto">
                                <div class="custom-file-container">
                                    <div class="cove_desktop_ar_file">
                                        <input type="file" name="cove_desktop_ar" class="cove_desktop_ar-input"
                                               id="cove_desktop_ar">
                                        <label class="custom-file-label"
                                               for="cove_desktop_ar">{{ trans('messages.cove_desktop_ar') }}</label>
                                    </div>
                                    <div class="bg-lightest p-10 rounded5 dvPreview text-center cove_desktop_Contrren_ar"
                                         style="width: 100%;margin-top: 1em;height: 10em;">
                                        <img style="max-width: 100%;height: 100%;" src="{{ url('/images/noimg.png') }}"
                                             alt="">
                                        <video style="max-width: 100%;height: 100%;display: none;" controls autoplay>

                                        </video>
                                    </div>
                                </div>
                                @error('cove_desktop_ar')
                                <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-lg-12 mx-auto">
                                <div class="custom-file-container_2">
                                    <div class="cove_phone_ar_2">
                                        <input type="file" name="cove_phone_ar" class="cove_phone_ar_2"
                                               id="cove_phone_ar">
                                        <label class="custom-file-label"
                                               for="cove_phone_ar">{{   trans('messages.cove_phone_ar') }}</label>
                                    </div>
                                    <div class="bg-lightest p-10 rounded5 dvPreview text-center cove_phone_ar_contener_2"
                                         style="width: 100%;margin-top: 1em;height: 10em;">
                                        <img style="max-width: 100%;height: 100%;" src="{{ url('/images/noimg.png') }}"
                                             alt="">
                                        <video style="max-width: 100%;height: 100%;display: none;" controls autoplay>

                                        </video>
                                    </div>
                                </div>
                                @error('cove_phone_ar')
                                <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group">
                            <div class="col-lg-12 mx-auto">
                                <div class="custom-file-container_2">
                                    <div class="cove_desktop_en_2">
                                        <input type="file" name="cove_desktop_en" class="cove_desktop_en_2"
                                               id="cove_desktop_en">
                                        <label class="custom-file-label"
                                               for="cove_desktop_en">{{ trans('messages.cove_desktop_en') }}</label>
                                    </div>
                                    <div class="bg-lightest p-10 rounded5 dvPreview text-center cove_desktop_en_contener_2"
                                         style="width: 100%;margin-top: 1em;height: 10em;">
                                        <img style="max-width: 100%;height: 100%;" src="{{ url('/images/noimg.png') }}"
                                             alt="">
                                        <video style="max-width: 100%;height: 100%;display: none;" controls autoplay>

                                        </video>
                                    </div>
                                </div>
                                @error('cove_desktop_en')
                                <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-lg-12 mx-auto">
                                <div class="custom-file-container_2">
                                    <div class="cove_phone_en_2">
                                        <input type="file" name="cove_phone_en" class="cove_phone_en_2"
                                               id="cove_phone_en">
                                        <label class="custom-file-label"
                                               for="cove_phone_en">{{ trans('messages.cove_phone_en') }}</label>
                                    </div>
                                    <div class="bg-lightest p-10 rounded5 dvPreview text-center cove_phone_en_contenr_2"
                                         style="width: 100%;margin-top: 1em;height: 10em;">
                                        <img style="max-width: 100%;height: 100%;" src="{{ url('/images/noimg.png') }}"
                                             alt="">
                                        <video style="max-width: 100%;height: 100%;display: none;" controls autoplay>

                                        </video>
                                    </div>
                                </div>
                                @error('cove_phone_en')
                                <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group">
                            <div class="col-lg-12 mx-auto">
                                <div class="custom-file-container_2">
                                    <div class="cove_desktop_nl_2">
                                        <input type="file" name="cove_desktop_nl" class="cove_desktop_nl_2"
                                               id="cove_desktop_nl">
                                        <label class="custom-file-label"
                                               for="cove_desktop_nl">{{ trans('messages.cove_desktop_nl') }}</label>
                                    </div>
                                    <div class="bg-lightest p-10 rounded5 dvPreview text-center cove_desktop_nl_contenre_2"
                                         style="width: 100%;margin-top: 1em;height: 10em;">
                                        <img style="max-width: 100%;height: 100%;" src="{{ url('/images/noimg.png') }}"
                                             alt="">
                                        <video style="max-width: 100%;height: 100%;display: none;" controls autoplay>

                                        </video>
                                    </div>
                                </div>
                                @error('cove_desktop_nl')
                                <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-lg-12 mx-auto">
                                <div class="custom-file-container_2">
                                    <div class="cove_phone_nl_2">
                                        <input type="file" name="cove_phone_nl" class="cove_phone_nl_2"
                                               id="cove_phone_nl">
                                        <label class="custom-file-label"
                                               for="cove_phone_nl">{{ trans('messages.cove_phone_nl') }}</label>
                                    </div>
                                    <div class="bg-lightest p-10 rounded5 dvPreview text-center cove_phone_nl_contern_2"
                                         style="width: 100%;margin-top: 1em;height: 10em;">
                                        <img style="max-width: 100%;height: 100%;" src="{{ url('/images/noimg.png') }}"
                                             alt="">
                                        <video style="max-width: 100%;height: 100%;display: none;" controls autoplay>

                                        </video>
                                    </div>
                                </div>
                                @error('cove_phone_en')
                                <div class="badge badge-danger text-center" style="width: 100%">{{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- /.box-body -->
                    <div class="box-footer">
                        <button type="submit" class="btn btn-rounded btn-primary btn-outline">
                            <i class="ti-save-alt"></i> {{ trans('messages.Save') }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
        {!! Form::Close() !!}
    </section>
@endsection

@section('script')
    <script type="text/javascript">
        $('.select2').select2();
        CKEDITOR.replace('editor1')
        CKEDITOR.replace('editoren')
        CKEDITOR.replace('editor2')
        $(document).ready(function () {
            $(window).keydown(function (event) {
                if (event.keyCode == 13) {
                    event.preventDefault();
                    return false;
                }
            });
        });
        $(".custom-file-input_2").change(function () {
            var fileInput = $(this)[0].files[0]; // الملف المرفوع
            var container = $(this).closest('.custom-file-container_2'); // تحديد الحاوية الرئيسية
            console.log(container);
            var imgSrc = container.find("img").length ? container.find("img") : null; // التحقق من وجود عنصر الصورة
            var videoSrc = container.find("video").length ? container.find("video") : null; // التحقق من وجود عنصر الفيديو
            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.jpg|.jpeg|.gif|.png|.bmp|.mp4|.mkv|.avi)$/; // التعبير النمطي للامتدادات المدعومة

            // التحقق إذا كان هناك ملف
            if (!fileInput) {
                alert("Please select a file.");
                return;
            }

            if (!regex.test(fileInput.name.toLowerCase())) {
                alert("Invalid file type. Please upload a valid image or video file.");
                imgSrc && imgSrc.attr("src", "").hide();
                videoSrc && videoSrc.remove();
                return;
            }
            var fileType = fileInput.type; // نوع الملف
            if (fileType.startsWith("image/") || fileType.startsWith("video/")) {
                if (typeof (FileReader) !== "undefined") {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        if (fileType.startsWith("image/")) {
                            if (imgSrc) {
                                // إذا كان هناك عنصر صورة
                                videoSrc && videoSrc.hide(); // إخفاء الفيديو إذا كان موجودًا
                                imgSrc.attr("src", e.target.result).show(); // عرض الصورة
                            } else {
                                alert("No image container found to display the uploaded image.");
                            }
                        } else if (fileType.startsWith("video/")) {
                            if (videoSrc) {
                                // إذا كان هناك عنصر فيديو
                                imgSrc && imgSrc.hide(); // إخفاء الصورة إذا كانت موجودة
                                videoSrc.attr("src", e.target.result).show(); // عرض الفيديو
                            } else {
                                // إذا لم يكن هناك عنصر فيديو، يتم إنشاؤه
                                videoSrc = $('<video controls autoplay style="width: 100%; height: auto;"></video>');
                                container.append(videoSrc);
                                videoSrc.attr("src", e.target.result).show();
                            }
                        }
                    };
                    reader.readAsDataURL(fileInput);
                } else {
                    alert("This browser does not support FileReader.");
                }
            } else {
                alert("Invalid file type. Please upload an image or video.");
            }
        });
        $(".custom-file-input_phone").change(function () {
            var fileInput = $(this)[0].files[0];
            var container = $(this).parents('.custom-file-container_2').find('.custom-file-input_phone_preview'); // تحديد الحاوية الصحيحة
            var imgSrc2 = container.find("img").length ? container.find("img") : null; // التحقق من وجود عنصر الصورة
            var videoSrc2 = container.find("video").length ? container.find("video") : null; // التحقق من وجود عنصر الفيديو
            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.jpg|.jpeg|.gif|.png|.bmp|.mp4|.mkv|.avi)$/; // التعبير النمطي للامتدادات المدعومة

            if (!fileInput) {
                alert("Please select a file.");
                return;
            }

            if (!regex.test(fileInput.name.toLowerCase())) {
                alert("Invalid file type. Please upload a valid image or video file.");
                imgSrc2 && imgSrc2.attr("src", "").hide();
                videoSrc2 && videoSrc2.remove();
                return;
            }
            var fileType = fileInput.type; // نوع الملف
            if (fileType.startsWith("image/") || fileType.startsWith("video/")) {
                if (typeof (FileReader) !== "undefined") {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        if (fileType.startsWith("image/")) {
                            if (imgSrc2) {
                                alert('yes');
                                // إذا كان هناك عنصر صورة
                                videoSrc2 && videoSrc2.hide(); // إخفاء الفيديو إذا كان موجودًا
                                imgSrc2.attr("src", e.target.result).show(); // عرض الصورة
                            } else {
                                alert("No image container found to display the uploaded image.");
                            }
                        } else if (fileType.startsWith("video/")) {
                            if (videoSrc2) {
                                // إذا كان هناك عنصر فيديو
                                imgSrc2 && imgSrc2.hide(); // إخفاء الصورة إذا كانت موجودة
                                videoSrc2.attr("src", e.target.result).show(); // عرض الفيديو
                            } else {
                                // إذا لم يكن هناك عنصر فيديو، يتم إنشاؤه
                                videoSrc2 = $('<video controls autoplay style="width: 100%; height: auto;"></video>');
                                container.append(videoSrc2);
                                videoSrc2.attr("src", e.target.result).show();
                            }
                        }
                    };
                    reader.readAsDataURL(fileInput);
                } else {
                    alert("This browser does not support FileReader.");
                }
            } else {
                alert("Invalid file type. Please upload an image or video.");
            }
        });
        $(".cove_phone_ar_2").change(function () {
            var fileInput = $(this)[0].files[0]; // الملف المرفوع
            var container = $(this).parents('.custom-file-container_2').find('.cove_phone_ar_contener_2');
            var imgSrc = container.find("img").length ? container.find("img") : null; // التحقق من وجود عنصر الصورة
            var videoSrc = container.find("video").length ? container.find("video") : null; // التحقق من وجود عنصر الفيديو
            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.jpg|.jpeg|.gif|.png|.bmp|.mp4|.mkv|.avi)$/; // التعبير النمطي للامتدادات المدعومة
            if (!fileInput) {
                alert("Please select a file.");
                return;
            }
            if (!regex.test(fileInput.name.toLowerCase())) {
                alert("Invalid file type. Please upload a valid image or video file.");
                imgSrc && imgSrc.attr("src", "").hide();
                videoSrc && videoSrc.remove();
                return;
            }
            var fileType = fileInput.type; // نوع الملف
            if (fileType.startsWith("image/") || fileType.startsWith("video/")) {
                if (typeof (FileReader) !== "undefined") {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        if (fileType.startsWith("image/")) {
                            if (imgSrc) {
                                // إذا كان هناك عنصر صورة
                                videoSrc && videoSrc.hide(); // إخفاء الفيديو إذا كان موجودًا
                                imgSrc.attr("src", e.target.result).show(); // عرض الصورة
                            } else {
                                alert("No image container found to display the uploaded image.");
                            }
                        } else if (fileType.startsWith("video/")) {
                            if (videoSrc) {
                                // إذا كان هناك عنصر فيديو
                                imgSrc && imgSrc.hide(); // إخفاء الصورة إذا كانت موجودة
                                videoSrc.attr("src", e.target.result).show(); // عرض الفيديو
                            } else {
                                // إذا لم يكن هناك عنصر فيديو، يتم إنشاؤه
                                videoSrc = $('<video controls autoplay style="width: 100%; height: auto;"></video>');
                                container.append(videoSrc);
                                videoSrc.attr("src", e.target.result).show();
                            }
                        }
                    };
                    reader.readAsDataURL(fileInput);
                } else {
                    alert("This browser does not support FileReader.");
                }
            } else {
                alert("Invalid file type. Please upload an image or video.");
            }
        });
        $(".cove_desktop_en_2").change(function () {
            var fileInput = $(this)[0].files[0]; // الملف المرفوع
            var container = $(this).parents('.custom-file-container_2').find('.cove_desktop_en_contener_2');
            var imgSrc = container.find("img").length ? container.find("img") : null; // التحقق من وجود عنصر الصورة
            var videoSrc = container.find("video").length ? container.find("video") : null; // التحقق من وجود عنصر الفيديو
            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.jpg|.jpeg|.gif|.png|.bmp|.mp4|.mkv|.avi)$/; // التعبير النمطي للامتدادات المدعومة
            if (!fileInput) {
                alert("Please select a file.");
                return;
            }
            if (!regex.test(fileInput.name.toLowerCase())) {
                alert("Invalid file type. Please upload a valid image or video file.");
                imgSrc && imgSrc.attr("src", "").hide();
                videoSrc && videoSrc.remove();
                return;
            }
            var fileType = fileInput.type; // نوع الملف
            if (fileType.startsWith("image/") || fileType.startsWith("video/")) {
                if (typeof (FileReader) !== "undefined") {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        if (fileType.startsWith("image/")) {
                            if (imgSrc) {
                                // إذا كان هناك عنصر صورة
                                videoSrc && videoSrc.hide(); // إخفاء الفيديو إذا كان موجودًا
                                imgSrc.attr("src", e.target.result).show(); // عرض الصورة
                            } else {
                                alert("No image container found to display the uploaded image.");
                            }
                        } else if (fileType.startsWith("video/")) {
                            if (videoSrc) {
                                // إذا كان هناك عنصر فيديو
                                imgSrc && imgSrc.hide(); // إخفاء الصورة إذا كانت موجودة
                                videoSrc.attr("src", e.target.result).show(); // عرض الفيديو
                            } else {
                                // إذا لم يكن هناك عنصر فيديو، يتم إنشاؤه
                                videoSrc = $('<video controls autoplay style="width: 100%; height: auto;"></video>');
                                container.append(videoSrc);
                                videoSrc.attr("src", e.target.result).show();
                            }
                        }
                    };
                    reader.readAsDataURL(fileInput);
                } else {
                    alert("This browser does not support FileReader.");
                }
            } else {
                alert("Invalid file type. Please upload an image or video.");
            }
        });
        $(".cove_phone_en_2").change(function () {
            var fileInput = $(this)[0].files[0]; // الملف المرفوع
            var container = $(this).parents('.custom-file-container_2').find('.cove_phone_en_contenr_2');
            var imgSrc = container.find("img").length ? container.find("img") : null; // التحقق من وجود عنصر الصورة
            var videoSrc = container.find("video").length ? container.find("video") : null; // التحقق من وجود عنصر الفيديو
            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.jpg|.jpeg|.gif|.png|.bmp|.mp4|.mkv|.avi)$/; // التعبير النمطي للامتدادات المدعومة
            if (!fileInput) {
                alert("Please select a file.");
                return;
            }
            if (!regex.test(fileInput.name.toLowerCase())) {
                alert("Invalid file type. Please upload a valid image or video file.");
                imgSrc && imgSrc.attr("src", "").hide();
                videoSrc && videoSrc.remove();
                return;
            }
            var fileType = fileInput.type; // نوع الملف
            if (fileType.startsWith("image/") || fileType.startsWith("video/")) {
                if (typeof (FileReader) !== "undefined") {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        if (fileType.startsWith("image/")) {
                            if (imgSrc) {
                                // إذا كان هناك عنصر صورة
                                videoSrc && videoSrc.hide(); // إخفاء الفيديو إذا كان موجودًا
                                imgSrc.attr("src", e.target.result).show(); // عرض الصورة
                            } else {
                                alert("No image container found to display the uploaded image.");
                            }
                        } else if (fileType.startsWith("video/")) {
                            if (videoSrc) {
                                // إذا كان هناك عنصر فيديو
                                imgSrc && imgSrc.hide(); // إخفاء الصورة إذا كانت موجودة
                                videoSrc.attr("src", e.target.result).show(); // عرض الفيديو
                            } else {
                                // إذا لم يكن هناك عنصر فيديو، يتم إنشاؤه
                                videoSrc = $('<video controls autoplay style="width: 100%; height: auto;"></video>');
                                container.append(videoSrc);
                                videoSrc.attr("src", e.target.result).show();
                            }
                        }
                    };
                    reader.readAsDataURL(fileInput);
                } else {
                    alert("This browser does not support FileReader.");
                }
            } else {
                alert("Invalid file type. Please upload an image or video.");
            }
        });
        $(".cove_phone_nl_2").change(function () {
            var fileInput = $(this)[0].files[0]; // الملف المرفوع
            var container = $(this).parents('.custom-file-container_2').find('.cove_phone_nl_contern_2');
            var imgSrc = container.find("img").length ? container.find("img") : null; // التحقق من وجود عنصر الصورة
            var videoSrc = container.find("video").length ? container.find("video") : null; // التحقق من وجود عنصر الفيديو
            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.jpg|.jpeg|.gif|.png|.bmp|.mp4|.mkv|.avi)$/; // التعبير النمطي للامتدادات المدعومة
            if (!fileInput) {
                alert("Please select a file.");
                return;
            }
            if (!regex.test(fileInput.name.toLowerCase())) {
                alert("Invalid file type. Please upload a valid image or video file.");
                imgSrc && imgSrc.attr("src", "").hide();
                videoSrc && videoSrc.remove();
                return;
            }
            var fileType = fileInput.type; // نوع الملف
            if (fileType.startsWith("image/") || fileType.startsWith("video/")) {
                if (typeof (FileReader) !== "undefined") {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        if (fileType.startsWith("image/")) {
                            if (imgSrc) {
                                // إذا كان هناك عنصر صورة
                                videoSrc && videoSrc.hide(); // إخفاء الفيديو إذا كان موجودًا
                                imgSrc.attr("src", e.target.result).show(); // عرض الصورة
                            } else {
                                alert("No image container found to display the uploaded image.");
                            }
                        } else if (fileType.startsWith("video/")) {
                            if (videoSrc) {
                                // إذا كان هناك عنصر فيديو
                                imgSrc && imgSrc.hide(); // إخفاء الصورة إذا كانت موجودة
                                videoSrc.attr("src", e.target.result).show(); // عرض الفيديو
                            } else {
                                // إذا لم يكن هناك عنصر فيديو، يتم إنشاؤه
                                videoSrc = $('<video controls autoplay style="width: 100%; height: auto;"></video>');
                                container.append(videoSrc);
                                videoSrc.attr("src", e.target.result).show();
                            }
                        }
                    };
                    reader.readAsDataURL(fileInput);
                } else {
                    alert("This browser does not support FileReader.");
                }
            } else {
                alert("Invalid file type. Please upload an image or video.");
            }
        });
        $(".cove_desktop_nl_2").change(function () {
            var fileInput = $(this)[0].files[0]; // الملف المرفوع
            var container = $(this).parents('.custom-file-container_2').find('.cove_desktop_nl_contenre_2');
            var imgSrc = container.find("img").length ? container.find("img") : null; // التحقق من وجود عنصر الصورة
            var videoSrc = container.find("video").length ? container.find("video") : null; // التحقق من وجود عنصر الفيديو
            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.jpg|.jpeg|.gif|.png|.bmp|.mp4|.mkv|.avi)$/; // التعبير النمطي للامتدادات المدعومة
            if (!fileInput) {
                alert("Please select a file.");
                return;
            }
            if (!regex.test(fileInput.name.toLowerCase())) {
                alert("Invalid file type. Please upload a valid image or video file.");
                imgSrc && imgSrc.attr("src", "").hide();
                videoSrc && videoSrc.remove();
                return;
            }
            var fileType = fileInput.type; // نوع الملف
            if (fileType.startsWith("image/") || fileType.startsWith("video/")) {
                if (typeof (FileReader) !== "undefined") {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        if (fileType.startsWith("image/")) {
                            if (imgSrc) {
                                // إذا كان هناك عنصر صورة
                                videoSrc && videoSrc.hide(); // إخفاء الفيديو إذا كان موجودًا
                                imgSrc.attr("src", e.target.result).show(); // عرض الصورة
                            } else {
                                alert("No image container found to display the uploaded image.");
                            }
                        } else if (fileType.startsWith("video/")) {
                            if (videoSrc) {
                                // إذا كان هناك عنصر فيديو
                                imgSrc && imgSrc.hide(); // إخفاء الصورة إذا كانت موجودة
                                videoSrc.attr("src", e.target.result).show(); // عرض الفيديو
                            } else {
                                // إذا لم يكن هناك عنصر فيديو، يتم إنشاؤه
                                videoSrc = $('<video controls autoplay style="width: 100%; height: auto;"></video>');
                                container.append(videoSrc);
                                videoSrc.attr("src", e.target.result).show();
                            }
                        }
                    };
                    reader.readAsDataURL(fileInput);
                } else {
                    alert("This browser does not support FileReader.");
                }
            } else {
                alert("Invalid file type. Please upload an image or video.");
            }
        });
        $(".cove_desktop_ar-input").change(function () {
            var fileInput = $(this)[0].files[0]; // الملف المرفوع
            var container = $(this).parents('.custom-file-container').find('.cove_desktop_Contrren_ar');
            var imgSrc = container.find("img").length ? container.find("img") : null; // التحقق من وجود عنصر الصورة
            var videoSrc = container.find("video").length ? container.find("video") : null; // التحقق من وجود عنصر الفيديو
            var regex = /^([a-zA-Z0-9\s_\\.\-:])+(.jpg|.jpeg|.gif|.png|.bmp|.mp4|.mkv|.avi)$/; // التعبير النمطي للامتدادات المدعومة
            if (!fileInput) {
                alert("Please select a file.");
                return;
            }
            if (!regex.test(fileInput.name.toLowerCase())) {
                alert("Invalid file type. Please upload a valid image or video file.");
                imgSrc && imgSrc.attr("src", "").hide();
                videoSrc && videoSrc.remove();
                return;
            }
            var fileType = fileInput.type; // نوع الملف
            if (fileType.startsWith("image/") || fileType.startsWith("video/")) {
                if (typeof (FileReader) !== "undefined") {
                    var reader = new FileReader();
                    reader.onload = function (e) {
                        if (fileType.startsWith("image/")) {
                            if (imgSrc) {

                                videoSrc && videoSrc.hide();
                                imgSrc.attr("src", e.target.result).show();
                            } else {
                                alert("No image container found to display the uploaded image.");
                            }
                        } else if (fileType.startsWith("video/")) {
                            if (videoSrc) {
                                // إذا كان هناك عنصر فيديو
                                imgSrc && imgSrc.hide(); // إخفاء الصورة إذا كانت موجودة
                                videoSrc.attr("src", e.target.result).show(); // عرض الفيديو
                            } else {
                                // إذا لم يكن هناك عنصر فيديو، يتم إنشاؤه
                                videoSrc = $('<video controls autoplay style="width: 100%; height: auto;"></video>');
                                container.append(videoSrc);
                                videoSrc.attr("src", e.target.result).show();
                            }
                        }
                    };
                    reader.readAsDataURL(fileInput);
                } else {
                    alert("This browser does not support FileReader.");
                }
            } else {
                alert("Invalid file type. Please upload an image or video.");
            }
        });
    </script>
@endsection
