@extends('site.layouts.main')
@section('meta_title')
    {{ trans('messages.Adnan Eltaher') . ' | ' . trans('messages.Theory Packages') }}
@stop
@section('content')
    <section class="container-fluid theory-package-wrapper">
        <div class="container">
            <div class="row top-row text-center">
                <h1 class="title">{{ trans('messages.videos') }}</h1>
            </div>

            <div class="row theory-package-cards mt-5 mb-5">
                @if(!empty($packages))
                    @forelse ($packages as $thpackage)
                        <div class="col-lg-3 col-md-3 col-sm-12 wrapper">
                            <div class="theory-package-card card"
                                 @if($thpackage->type_view != 'photo')
                                     style="border: 1px solid {{$thpackage->color_border !=null?$thpackage->color_border:"transparent" }} ;background:{{$thpackage->color_background !=null?$thpackage->color_background:"transparent" }} ;"
                                @endif
                            >
                                <a style="text-decoration:none" href="{{ route('ShowVideos', $thpackage->id) }}"
                                >
                                    <div class="row">
                                        @if($thpackage->type_view != 'photo')
                                            <div class="col-md-12 col-4">
                                                <div class="theory-package-img-wrapper">
                                                    @if ($thpackage->photo_desktop)
                                                        @if(in_array(pathinfo($thpackage->photo_desktop, PATHINFO_EXTENSION),["JPG","jpg","jpeg","gif","png","bmp"]))

                                                            <img class="course-img-desktop"
                                                                 src="{{ asset($thpackage->photo_desktop) }}"
                                                                 alt="">
                                                        @else
                                                            <video class="course-img-desktop"
                                                                   src="{{ url($thpackage->photo_desktop) }}"
                                                                   controls autoplay>
                                                            </video>

                                                        @endif
                                                    @endif
                                                    @if ($thpackage->photo_phone)
                                                        @if(in_array(pathinfo($thpackage->photo_phone, PATHINFO_EXTENSION),["JPG","jpg","jpeg","gif","png","bmp"]))

                                                            <img class="course-img-mobile d-none"
                                                                 src="{{ asset($thpackage->photo_phone) }}"
                                                                 alt="">
                                                        @else
                                                            <video class="course-img-desktop"
                                                                   src="{{ url($thpackage->photo_phone) }}"
                                                                   controls autoplay>
                                                            </video>

                                                        @endif
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-md-12 col-6">
                                                <h5 class="title">{{ $thpackage->{'name_' . App::getLocale()} }}</h5>
                                                <div class="content-wrapper">
                                                    <p class="desc">
                                                        {{ $thpackage->{'notes_' . App::getLocale()} }}
                                                    </p>
                                                </div>
                                            </div>
                                        @else
                                            <div class="col-md-12 col-4">
                                                <div class="theory-package-img-wrapper">
                                                    @if ($thpackage->{'cove_desktop_' . App::getLocale()})
                                                        @if(in_array(pathinfo($thpackage->{'cove_desktop_' . App::getLocale()}, PATHINFO_EXTENSION),["JPG","jpg","jpeg","gif","png","bmp"]))
                                                            <img class="course-img-desktop"
                                                                 src="{{ asset($thpackage->{'cove_desktop_' . App::getLocale()}) }}"
                                                                 style="height: auto; box-shadow:0 0 6px 0 rgba(0, 0, 0, 0.16); border:1px solid rgba(0,0,0,.125); object-fit: contain;aspect-ratio: 1 / 1; width: 100%;"
                                                                 alt="">
                                                        @else
                                                            <video class="course-img-desktop"
                                                                   style="height: auto; box-shadow:0 0 6px 0 rgba(0, 0, 0, 0.16); border:1px solid rgba(0,0,0,.125); object-fit: contain;aspect-ratio: 1 / 1; width: 100%;"
                                                                   src="{{ asset($thpackage->{'cove_desktop_' . App::getLocale()}) }}"
                                                                   controls autoplay>
                                                            </video>
                                                        @endif
                                                    @endif
                                                    @if ($thpackage->{'cove_phone_' . App::getLocale()})
                                                        @if(in_array(pathinfo($thpackage->{'cove_phone_' . App::getLocale()}, PATHINFO_EXTENSION),["JPG","jpg","jpeg","gif","png","bmp"]))
                                                            <img class="course-img-mobile d-none"
                                                                 style="height: 300px ;box-shadow:0 0 6px 0 rgba(0, 0, 0, 0.16); border:1px solid rgba(0,0,0,.125); object-fit: contain;aspect-ratio: 1 / 1; width: auto;"
                                                                 src="{{ asset($thpackage->{'cove_phone_' . App::getLocale()}) }}"
                                                                 alt="">
                                                        @else
                                                            <video class="course-img-mobile d-none"
                                                                   style="height: 300px ;box-shadow:0 0 6px 0 rgba(0, 0, 0, 0.16); border:1px solid rgba(0,0,0,.125); object-fit: contain;aspect-ratio: 1 / 1; width: auto;"
                                                                   src="{{ asset($thpackage->{'cove_phone_' . App::getLocale()}) }}"
                                                                   controls autoplay>
                                                            </video>
                                                        @endif

                                                    @endif
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                </a>
                            </div>
                        </div>
                    @empty
                    @endforelse
                @endif
            </div>
        </div>

    </section>
@endsection

