<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::namespace('Api')->group(function () {
    // Auth Countrollers
    Route::prefix('auth')->group(function () {
        Route::namespace('Auth')->group(function () {
            Route::post('/login', 'AuthCountrollers@login')->name('auth.login');
            Route::post('/register', 'AuthCountrollers@register')->name('auth.register');
            Route::get('/me', 'AuthCountrollers@me')->name('auth.me');
            Route::get('/checkPayment/{id}', 'AuthCountrollers@checkPayment')->name('auth.checkPayment');
        });
    });
    // any general data
    Route::prefix('general')->group(function () {
        Route::namespace('General')->group(function () {
            Route::get('/payment-method', 'PaymentControllers@getPaymentMethods')->name('general.payment-methods');
        });
    });
    Route::prefix('packages')->group(function () {
        Route::namespace('Packages')->group(function () {
            Route::get('get/{limit}', 'PackagesControllers@packages')->name('packages.active');
        });
    });
});


Route::post('mollie-webhooks/{type}', [App\Http\Controllers\Site\ClientController::class, 'handleWebhookNotification'])->name('webhooks.mollie');
Route::post('mollie-webhooks-theory', [App\Http\Controllers\Site\ClientController::class, 'handleWebhookTheoryNotification'])->name('webhooks.mollieTheory');
Route::post('mollie-webhooks-packageVideos', [App\Http\Controllers\Site\PackagesVideosControllers::class, 'handleWebhookpackageVideos'])->name('webhooks.packageVideos');
