
<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"><?php echo e(trans('messages.Roles')); ?></h3>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <div class="row">
                    <div class="col-4">
                        <div class="app-menu">
                            <div class="search-bx mx-5">
                                <form action="<?php echo e(route('role.index')); ?>" method="GET">
                                    <div class="input-group">
                                        <input type="search" id="search" class="form-control" name="search"
                                            <?php if(isset($sort_search)): ?> value="<?php echo e($sort_search); ?>" <?php endif; ?>
                                            placeholder="<?php echo e(trans('messages.Name')); ?>" aria-label="Search"
                                            aria-describedby="button-addon2">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col" style="text-align: end">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role_create')): ?>
                            <a href="<?php echo e(route('role.create')); ?>"
                                class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                    class="mdi mdi-plus"><span class="path1"></span><span class="path2"></span></span></a>
                        <?php endif; ?>

                    </div>
                </div>

            </div>
            <div class="box-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr class="">
                                <th class="text-center">
                                    #
                                </th>
                                <th class="text-center"> <?php echo e(trans('messages.Name')); ?></th>
                                <th class="text-center"> <?php echo e(trans('messages.Options')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($role->id != 1): ?>
                                    <tr class="bg-table-gray changnametr">
                                        <td class="text-center">
                                            <?php echo e($key + 1 + ($roles->currentPage() - 1) * $roles->perPage()); ?>

                                        </td>
                                        <td class="text-center"><?php echo e($role->name); ?></td>

                                        <td class="text-center">
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role_delete')): ?>
                                                <form action="<?php echo e(route('role.destroy', $role->id)); ?>" method="Post"
                                                    id="destroy-form">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                </form>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role_view')): ?>
                                                <a href="#" onclick="view_role(<?php echo e($role->id); ?>)"
                                                    class="waves-effect waves-light btn btn-primary-light btn-circle mx-5"><span
                                                        class="mdi mdi-magnify"><span class="path1"></span><span
                                                            class="path2"></span></span></a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role_update')): ?>
                                                <a href="<?php echo e(route('role.edit', $role->id)); ?>"
                                                    class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                        class="icon-Write"><span class="path1"></span><span
                                                            class="path2"></span></span></a>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role_delete')): ?>
                                                <a data-title="<?php echo e(trans('messages.Are you sure?')); ?>"
                                                    data-no="<?php echo e(trans('messages.Cancel')); ?>"
                                                    data-yes="<?php echo e(trans('messages.Yes, delete it!')); ?>"
                                                    data-desc="<?php echo e(trans('messages.You will not be able to recover this!')); ?>"
                                                    href="#" data-href="<?php echo e(route('role.destroy', $role->id)); ?>"
                                                    class="sa-warning waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                        class="icon-Trash1"><span class="path1"></span><span
                                                            class="path2"></span></span></a>
                                            <?php endif; ?>
                                        </td>

                                    </tr>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <div class="dataTables_paginate paging_simple_numbers" id="example_paginate">
                        <?php echo e($roles->withQueryString()->links('pagination::bootstrap-4')); ?>

                    </div>
                </div>
            </div>
        </div>

    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-role">

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        function view_role(id) {
            $('#modal-left').modal();
            var url = `<?php echo e(route('role.show', 'role_id')); ?>`;
            url = url.replace('role_id', id);
            $.get(url, {}, function(data) {
                $('#view-role').html(data);
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\eltaher\resources\views/admin/Role/index.blade.php ENDPATH**/ ?>