<!DOCTYPE html>
<html lang="<?php echo e(App::getLocale()); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(trans('messages.Adnan Eltaher')); ?> | <?php echo e(trans('messages.Signup')); ?></title>
    <link href="<?php echo e(url('front_them/assets/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(url('front_them/assets/css/all.min.css')); ?>"/>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat&family=Tajawal&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(url('front_them/assets/css/style_' . App::getLocale() . '.css')); ?>">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/ms-dropdown@4.0.3/dist/css/dd.min.css" />
</head>
<style>
    .ms-dd {
        width:100%
    }

    .singup-container .package-card {
        transition: 0.4s all ease;
        cursor: pointer;
    }

    .singup-container .package-card:hover {
        transform:scale(1.05)
    }
</style>
<body>
<nav>
    <div class="container-fluid d-flex align-items-center justify-content-between">
        <a href="<?php echo e(route('home')); ?>" class="logo">
            <img src="<?php echo e(url('front_them/assets/imgs/small-logo.png')); ?>" alt="">
        </a>
        <div class="adnan-txt text-center" style="color:#1ba9ff; font-size:30px; font-weight:700;">
            <span class="d-block">Adnan Eltaher</span>
            <span class="d-block">عدنان الطاهر</span>
        </div>
        <a href="<?php echo e(url()->previous()); ?>" class="back text-center d-block" style="cursor:pointer;text-decoration:none">
            <img src="<?php echo e(url('front_them/assets/imgs/back-arrow.png')); ?>" alt="" style="width:70px; height:70px">
            <span class="d-block txt" style="color:#1ba9ff; font-size:22px; font-weight:700">
              <?php echo e(__('messages.Back')); ?>

                </span>
        </a>
    </div>
</nav>
<section class="container-fluid singup-container" style="overflow: auto; scroll-behavior: auto;height: 100%;">
    <div class="row justify-content-center">
        <div class="col-lg-4 col-md-6 col-sm-12 singup-form-wrapper">

            <div class="row">

                <form method="POST" action="<?php echo e(route('purchasePackage')); ?>">
                    <?php echo csrf_field(); ?>
                    <?php if(!empty($packeds)): ?>
                        <?php $__currentLoopData = $packeds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $packed): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-12 mb-3">
                                <label for="<?php echo e($packed->id); ?>" class="package-card"
                                       style="position:relative; background-color:<?php echo e($packed->color_background!= null?$packed->color_background:'#0000ff30'); ?>; border:1px solid <?php echo e($packed->color_border!= null?$packed->color_border:'#b3b3b3'); ?>; width:100%; border-radius:5px; padding:0.5rem 2rem 0.5rem 0.5rem;">

                                    <!-- <div class="ribbon ribbon-top-right"><span>ribbon</span></div> -->
                                    <?php if($packed->{'badge_' . App::getLocale()} != null): ?>
                                        <div class="ribbon ribbon-top-right">
                                            <span><?php echo e($packed->{'badge_' . App::getLocale()}); ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <div class="package-wrapper">
                                        <div class="package-header d-flex align-items-center justify-content-between">
                                    <span class="package-price" style="font-size:20px; font-weight:900">

                                        <?php if($packed->offer): ?>
                                            <sub
                                                class="before"><?php echo e($packed->price); ?></sub>
                                            <span><?php echo e($packed->price - $packed->offer->discount_amount); ?></span>
                                        <?php else: ?>
                                            <?php echo e($packed->price); ?>

                                        <?php endif; ?>
                                          €
                                    </span>
                                            <div>
                                                <div class="package-select">
                                                    <input type="radio" id="<?php echo e($packed->id); ?>"
                                                           name="package"  class="form-check-input"
                                                           value="<?php echo e($packed->id); ?>" required>
                                                    <span style="font-size:16px; font-weight:700"><?php echo e($packed->{'name_' . App::getLocale()}); ?></span>
                                                </div>
                                                <div class="package-options">
                                                    <ul style="list-style-type:none" class="">
                                                        <?php echo $packed->{'notes_' . App::getLocale()}; ?>

                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <div class="control-wrapper mb-3">
                        <select class="tech" name="payment" is="ms-dropdown" required>
                            <?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option data-image="<?php echo e($method->image->svg); ?>" value="<?php echo e($method->id); ?>"><?php echo e($method->description); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['payment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <small class="error text-danger"><?php echo e($message); ?></small>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>


                    <button class="btn btn-block mt-4"
                            type="submit"><?php echo e(trans('messages.voltooi')); ?></button>
                </form>

            </div>


        </div>
    </div>
</section>
<script src="<?php echo e(url('front_them/assets/js/popper.min.js')); ?>"></script>
<script src="<?php echo e(url('front_them/assets/js/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(url('front_them/assets/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(url('front_them/assets/js/swiper-bundle.min.js')); ?>"></script>
<script src="<?php echo e(url('front_them/assets/js/index.js')); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/ms-dropdown@4.0.3/dist/js/dd.min.js"></script>
<script type="text/javascript">
    $('#register-user-form').submit(function (event) {
        var emailone = $('#sinup-email').val();
        var emailtwo = $('#sinup-email-verified').val();
        if (emailone != emailtwo) {
            event.preventDefault();
            $('#verify-email-alert').show();
            setTimeout(() => {
                $('#verify-email-alert').hide();
            }, 2000);
        }
    });
</script>
</body>


</html>
<?php /**PATH /var/www/vhosts/aatheorie.nl/httpdocs/resources/views/site/getpayment.blade.php ENDPATH**/ ?>