
<?php $__env->startSection('meta_title'); ?><?php echo e(trans('messages.Adnan Eltaher') . ' | ' . $article->{'title_' . App::getLocale()}); ?><?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="container-fluid article-page-wrapper">
        <div class="container">
            <div class="row breadcrumb-row">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>"><?php echo e(trans('Home')); ?></a></li>
                        <li class="breadcrumb-item"><a
                                href="<?php echo e(route('blog', $article->blogCategory->{'slug_' . App::getLocale()})); ?>"><?php echo e(trans('messages.Blog')); ?></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">
                            <?php echo e($article->blogCategory->{'name_' . App::getLocale()}); ?></li>
                    </ol>
                </nav>
            </div>
            <div class="row article-wrapper mt-3 mb-5 ">
                <div class="col-lg-10 col-md-10 col-sm-12 article-content-wrapper">
                    <div class="article-card">
                        <div class="blog-img-wrapper">
                            <img src="<?php echo e(url($article->image)); ?>" alt="">

                        </div>
                        <div class="content-wrapper">
                            <div class="date">
                                <span><?php echo e(time_elapsed_string(date('Y-m-d H:i', strtotime($article->created_at)))); ?></span>
                            </div>
                            <h1 class="title"><?php echo e($article->{'title_' . App::getLocale()}); ?></h1>
                            <p class="desc">
                                <?php echo $article->{'body_' . App::getLocale()}; ?>

                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-md-2 col-sm-12 share-content-wrapper">
                    <div class="share-wrapper">
                        <p class="text">شارك الموضوع</p>
                        <ul class="links-list">
                            <div class="ss-box" data-ss-social="facebook, twitter, whatsapp, email, messenger"
                                data-ss-messenger="app_id: 123456" ss-responsive data-ss-content="false"></div>

                        </ul>
                    </div>
                </div>
            </div>
            <div class="row comments-wrapper mb-5 ">
                <div class="col-lg-10 col-md-10 col-sm-12 comments-content-wrapper">
                    <?php if(auth()->guard()->guest()): ?>
                    <?php else: ?>
                        <div class="add-comment-wrapper">
                            <?php echo Form::open([
                                'route' => 'blogCommentStore',
                                'files' => true,
                                'id' => 'add-blog-comment-form',
                            ]); ?>

                            <?php echo Form::hidden('blog_id', $article->id, []); ?>

                            <?php echo Form::hidden('user_id', Auth::user()->id, []); ?>

                            <div class="mb-3">
                                <label for="comment" class="form-label"><?php echo e(trans('messages.Write your comment here')); ?></label>
                                <?php echo Form::textarea('comment', null, [
                                    'id' => 'comment',
                                    'class' => 'form-control',
                                    'rows' => '3',
                                ]); ?>

                            </div>
                            <div class="btn-wrapper">
                                <button class="btn" type="submit"><?php echo e(trans('messages.Send')); ?></button>
                            </div>
                            <?php echo Form::Close(); ?>

                        </div>
                        <hr />
                    <?php endif; ?>


                    <div class="comment-list" id="comment-list">
                        <p class="title"><?php echo e(trans('messages.Comments')); ?></p>
                        <?php $__empty_1 = true; $__currentLoopData = $article->comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="comment">
                                <p class="name"><?php echo e($comment->user->name); ?></p>
                                <p class="date-time">
                                    <?php echo e(time_elapsed_string(date('Y-m-d H:i', strtotime($comment->created_at)))); ?>

                                </p>
                                <p class="comment-text">
                                    <?php echo e($comment->comment); ?>

                                </p>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="no-data">
                                <i class="fa-solid fa-comment-slash"></i>
                                <p><?php echo e(trans('messages.There are no comments yet')); ?></p>
                            </div>
                        <?php endif; ?>


                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $('#add-blog-comment-form').on('submit', function(e) {
            e.preventDefault();
            var formData = new FormData(this);
            if ($('#comment').val() == '') {
                $('#comment').css('border','2px solid red');
                setTimeout(() => {
                    $('#comment').css('border','2px solid #ccc');
                }, 2000);
            } else {
                $.ajax({
                    url: "<?php echo e(route('blogCommentStore')); ?>",
                    type: "POST",
                    data: formData,
                    success: function(msg) {
                        $('#comment').val('')
                        $.post(`<?php echo e(route('getBlogComments')); ?>`, {
                            _token: '<?php echo e(csrf_token()); ?>',
                            blog_id: <?php echo e($article->id); ?>

                        }, function(data) {
                            $('#comment-list').html(data);
                        });
                    },
                    error: function(xhr, status, error) {
                        console.log(error)
                    },
                    cache: false,
                    contentType: false,
                    processData: false
                });
            }

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('site.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/aatheorie.nl/demo.aatheorie.nl/resources/views/site/article.blade.php ENDPATH**/ ?>