<?php $__env->startSection('meta_title'); ?><?php echo e(trans('messages.Adnan Eltaher') . ' | ' . trans('messages.Account')); ?><?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="container-fluid account-page-wrapper">
        <div class="container">
            <div class="row title-row mb-5 text-center">
                <h1 class=" title "><?php echo e(Auth::user()->name); ?></h1>
            </div>
            <div class="row mt-3 mb-5">
                <div class="col-lg-10 col-md-12 col-sm-12 nav-links-wrapper m-auto">
                    <nav class="nav nav-pills flex-column flex-sm-row">
                        <a class="flex-sm-fill text-sm-center nav-link active" id="personal-info">
                            <i class="fa-regular fa-address-card"></i> <span><?php echo e(trans('messages.Personal Info')); ?></span>
                        </a>
                        <a class="flex-sm-fill text-sm-center nav-link" id="personal-sub">
                            <i class="fa-solid fa-id-card-clip"></i> <span><?php echo e(trans('messages.Subscribtions')); ?></span>
                        </a>
                        <a class="flex-sm-fill text-sm-center nav-link" id="personal-password">
                            <i class="fa-solid fa-lock"></i>
                            <span><?php echo e(trans('messages.Change password')); ?></span>
                        </a>
                    </nav>
                </div>
            </div>
            <div class="row personal-info mt-2" id="personal-info-wrapper">
                <div class="col-lg-6 col-md-10 col-sm-12 info-card-wrapper m-auto">
                    <div class="item">
                        <span class="head"><?php echo e(trans('messages.Username')); ?> : </span>
                        <span class="data"><?php echo e(Auth::user()->name); ?></span>
                    </div>
                    <div class="item">
                        <span class="head"><?php echo e(trans('messages.Email')); ?> : </span>
                        <span class="data"><?php echo e(Auth::user()->email); ?></span>
                    </div>
                    <div class="item">
                        <span class="head"><?php echo e(trans('messages.Subscribed since')); ?>: </span>
                        <span
                            class="data"><?php echo e(time_elapsed_string(date('Y-m-d H:i', strtotime(Auth::user()->created_at)))); ?></span>
                    </div>
                </div>
                <div class="col-12 btn-wrapper mt-5">
                    <a class=" btn logout " href="<?php echo e(route('logout')); ?>"
                        onclick="event.preventDefault();document.getElementById('logout-form').submit();"><?php echo e(trans('messages.Logout')); ?></a>
                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                        <?php echo csrf_field(); ?>
                    </form>
                </div>
            </div>
            <div class="row change-password mt-2" id="personal-password-wrapper">
                <div class="col-lg-6 col-md-10 col-sm-12 password-card-wrapper m-auto">
                    <?php if(session('error')): ?>
                        <div class="alert alert-danger">
                            <?php echo e(session('error')); ?>

                        </div>
                    <?php endif; ?>
                    <?php if(session('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>
                    <?php echo Form::open(['route' => 'password.change']); ?>

                    <div class="control-wrapper mb-3">
                        <label for="change-current-password"
                            class="form-label"><?php echo e(trans('messages.Old Password')); ?></label>
                        <div class="input-wrapper">
                            <input type="password" class="form-control" aria-describedby="change-current-password-eye-btn"
                                id="change-current-password" placeholder="******" name="current_password" required>
                            <button class="btn" type="button" id="change-current-password-btn">
                                <i class="fa-regular fa-eye" id="change-current-password-icon"></i>
                            </button>
                        </div>
                        <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="error text-danger"><?php echo e($message); ?></small>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="control-wrapper mb-3">
                        <label for="change-new-password" class="form-label"><?php echo e(trans('messages.New Password')); ?></label>
                        <div class="input-wrapper">
                            <input type="password" class="form-control" aria-describedby="change-new-password-eye-btn"
                                id="change-new-password" placeholder="******" name="new_password" required>
                            <button class="btn" type="button" id="change-new-password-btn">
                                <i class="fa-regular fa-eye" id="change-new-password-icon"></i>
                            </button>
                        </div>
                        <?php $__errorArgs = ['new_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="error text-danger"><?php echo e($message); ?></small>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="control-wrapper mb-3">
                        <label for="change-confirm-password"
                            class="form-label"><?php echo e(trans('messages.confirm password')); ?></label>
                        <div class="input-wrapper">
                            <input type="password" class="form-control" aria-describedby="change-confirm-password-btn"
                                id="change-confirm-password" placeholder="******" name="new_password_confirmation" required>
                            <button class="btn" type="button" id="change-confirm-password-btn">
                                <i class="fa-regular fa-eye" id="change-confirm-password-icon"></i>
                            </button>
                        </div>
                        <?php $__errorArgs = ['new_password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="error text-danger"><?php echo e($message); ?></small>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <button class="btn btn-block mt-4" type="submit"><?php echo e(trans('messages.Reset Password')); ?></button>
                    <?php echo Form::Close(); ?>

                </div>
            </div>
            <div class="row subscriptions mt-2" id="personal-sub-wrapper">
                <div class="col-lg-6 col-md-10 col-sm-12 subscriptions-card-wrapper m-auto">
                    <div class="row sub-head-row">
                        <h3><?php echo e(trans('messages.Current subscribtions')); ?></h3>
                    </div>

                    <?php $__empty_1 = true; $__currentLoopData = $current_subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="row sub-row">
                            <div class="col-12 sub-item">
                                <div class="package-data">
                                    <h5><?php echo e($subscription->package->{'name_' . App::getLocale()}); ?></h5>
                                    <span class="price"><?php echo e($subscription->price - $subscription->offer_discount); ?>

                                        €</span>
                                    <?php if($subscription->renewed_times > 0): ?>
                                        <hr>
                                        <span><?php echo e(trans('messages.Renewed ') . $subscription->renewed_times . trans('messages. Times')); ?></span>
                                    <?php endif; ?>
                                </div>
                                <div class="sub-btn">
                                    <button
                                        class="btn"><?php echo e(trans('messages.Remaining ') . now()->diffInDays(\Carbon\Carbon::parse($subscription->expiration_date)) . trans('messages. Day')); ?></button>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="row no-sub-row">
                            <img src="/assets/imgs/no-sub-image.png" alt="">
                            <p class="text"><?php echo e(trans('messages.There are no current subscriptions')); ?></p>
                        </div>
                    <?php endif; ?>

                    <div class="row sub-head-row mt-5">
                        <h3><?php echo e(trans('messages.previous subscriptions')); ?></h3>
                    </div>
                    <?php if(session('error')): ?>
                        <div class="alert alert-danger" style="margin-bottom: 3em">
                            <?php echo e(session('error')); ?>

                        </div>
                    <?php endif; ?>
                    <?php $__empty_1 = true; $__currentLoopData = $previous_subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="row sub-row">
                            <?php if(session('error1')): ?>
                                <div class="alert alert-danger" style="margin-bottom: 3em">
                                    <?php echo e(session('error1')); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(session('success1')): ?>
                                <div class="alert alert-success" style="margin-bottom: 3em">
                                    <?php echo e(session('success1')); ?>

                                </div>
                            <?php endif; ?>
                            <div class="col-12 sub-item">
                                <div class="package-data">
                                    <h5><?php echo e($subscription->package->{'name_' . App::getLocale()}); ?></h5>
                                    <span class="price"><?php echo e($subscription->price - $subscription->offer_discount); ?>

                                        €</span>
                                    <hr>
                                    <span><?php echo e(trans('messages.Expired from ') . now()->diffInDays(\Carbon\Carbon::parse($subscription->expiration_date)) . trans('messages. Day')); ?></span>
                                </div>
                                <div class="sub-btn">
                                    <?php if($subscription->offer_id != null): ?>
                                        <a class="btn"
                                            href="<?php echo e(route('purchasePackage', ['offer', $subscription->offer_id])); ?>"><?php echo e(trans('messages.Renew')); ?></a>
                                    <?php else: ?>
                                        <a href="<?php echo e(route('purchasePackage', ['package', $subscription->package_id])); ?>"
                                            class="btn"><?php echo e(trans('messages.Renew')); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="row no-sub-row">
                            <img src="/assets/imgs/no-sub-image.png" alt="">
                            <p class="text"><?php echo e(trans('messages.There are no previous subscriptions')); ?></p>
                        </div>
                    <?php endif; ?>


                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <?php if(session('error') || session('success')): ?>
        <script type="text/javascript">
            $('#personal-info').removeClass('active');
            $('#personal-password').addClass('active');
            $('#personal-info-wrapper').hide();
            $('#personal-password-wrapper').show();
        </script>
    <?php endif; ?>

    <?php if(session('error1') || session('success1')): ?>
        <script type="text/javascript">
            $('.nav-link').removeClass('active');
            $('#personal-sub').addClass('active');
            $('#personal-info-wrapper').hide();
            $('#personal-sub-wrapper').show();
        </script>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('site.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/aatheorie.nl/httpdocs/resources/views/site/account.blade.php ENDPATH**/ ?>