<!DOCTYPE html>
<html lang="<?php echo e(App::getLocale()); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('meta_title', trans('messages.Adnan Eltaher') . ' | ' . trans('messages.Home')); ?></title>
    <link href="<?php echo e(url('front_them/assets/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(url('front_them/assets/css/all.min.css')); ?>" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat&family=Tajawal&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(url('front_them/assets/css/swiper-bundle.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(url('front_them/assets/css/animate.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(url('front_them/assets/css/social-share.min.css')); ?>">
    <link rel='stylesheet' href='https://bevacqua.github.io/dragula/dist/dragula.css'>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <link rel="stylesheet" href="<?php echo e(url('front_them/assets/css/style_' . App::getLocale() . '.css')); ?>">
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/ms-dropdown@4.0.3/dist/css/dd.min.css" />

</head>

<body>
    <header class="<?php echo e(Route::currentRouteName() == 'home' ? '' : 'navbar-pages'); ?>">
        <?php echo $__env->make('site.includes.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php if(Route::currentRouteName() == 'home'): ?>
            <?php echo $__env->make('site.includes.home_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
    </header>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('site.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('modal'); ?>
    <script src="<?php echo e(url('panel_them/assets/theme_components/jquery-toast-plugin-master/src/jquery.toast.js')); ?>"></script>
    <script src="<?php echo e(url('front_them/assets/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(url('front_them/assets/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(url('front_them/assets/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(url('front_them/assets/js/swiper-bundle.min.js')); ?>"></script>
    <script src="<?php echo e(url('front_them/assets/js/social-share.min.js')); ?>"></script>
    <script src="<?php echo e(url('front_them/assets/js/sweetalert2.js')); ?>"></script>
    <script type="module" src="<?php echo e(url('front_them/assets/js/test.js')); ?>"></script>
    <script src="<?php echo e(url('front_them/assets/js/index.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/ms-dropdown@4.0.3/dist/js/dd.min.js"></script>
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <?php echo $__env->make('sweetalert::alert', ['cdn' => "https://cdn.jsdelivr.net/npm/sweetalert2@11"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('script'); ?>
    <script type="text/javascript">
        $('.lang-change').on('click', function(e) {
            e.preventDefault();
            var locale = $(this).attr('data-code');
            $.post('<?php echo e(route('language.change')); ?>', {
                _token: '<?php echo e(csrf_token()); ?>',
                locale: locale
            }, function(data) {
                location.reload();
            });

        });

    </script>
</body>
</html>
<?php /**PATH E:\localhost\htdocs\newTaher\resources\views/site/layouts/main.blade.php ENDPATH**/ ?>