<?php $__env->startSection('meta_title'); ?><?php echo e(trans('messages.Adnan Eltaher') . ' | ' . trans('messages.Home')); ?><?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="packages container">
        <div class="row top-row text-center">
            <h1 class="title"><?php echo e(trans('messages.Packages and offers')); ?></h1>
            <div class="filter-btns mb-4">
                <button class="btn active" id="packages-btn">
                    <span>
                        <?php echo e(trans('messages.Packages')); ?>

                    </span>
                </button>
                <button class="btn" id="offers-btn">
                    <i class="fa-solid fa-certificate"></i>
                    <span><?php echo e(trans('messages.Offers')); ?></span>
                </button>
            </div>
        </div>
        <div class="row cards-row" id="packages-cards">
            <?php if(session('error')): ?>
                <div class="alert alert-danger" style="margin-bottom: 3em">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            <?php $__empty_1 = true; $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php if($package->{'badge_' . App::getLocale()}): ?>
                    <div class="package-wrapper active animate__animated animate__zoomIn">
                        <div class="ribbon"><span><?php echo e($package->{'badge_' . App::getLocale()}); ?></span></div>
                        <h4 class="title"><?php echo e($package->{'name_' . App::getLocale()}); ?></h4>
                        <div class="price-wrapper">
                            <p class="price">
                                <!-- <sub class="before">100</sub> -->
                                <span><?php echo e($package->price); ?></span>
                                <sub>€</sub>
                            </p>
                        </div>
                        <ul class="features">
                            <?php echo $package->{'notes_' . App::getLocale()}; ?>

                        </ul>
                        <a href="<?php echo e(route('purchasePackage', ['package', $package->id])); ?>"
                            class="btn"><?php echo e(trans('messages.Start now')); ?></a>
                    </div>
                <?php else: ?>
                    <div class="package-wrapper animate__animated animate__zoomIn">
                        <h4 class="title"><?php echo e($package->{'name_' . App::getLocale()}); ?></h4>
                        <div class="price-wrapper">
                            <p class="price">
                                <!-- <sub class="before">100</sub> -->
                                <span><?php echo e($package->price); ?></span>
                                <sub>€</sub>
                            </p>
                        </div>
                        <ul class="features">
                            <?php echo $package->{'notes_' . App::getLocale()}; ?>

                        </ul>
                        <a href="<?php echo e(route('purchasePackage', ['package', $package->id])); ?>"
                            class="btn"><?php echo e(trans('messages.Start now')); ?></a>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <h3><?php echo e(trans('messages.No Packages')); ?></h3>
            <?php endif; ?>
        </div>
        <div class="row cards-row" id="offers-cards">
            <?php if(session('error')): ?>
                <div class="alert alert-danger" style="margin-bottom: 3em">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            <?php $__empty_1 = true; $__currentLoopData = $offers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php if($offer->package->{'badge_' . App::getLocale()}): ?>
                    <div class="package-wrapper active animate__animated animate__zoomIn">
                        <div class="ribbon"><span><?php echo e($offer->package->{'badge_' . App::getLocale()}); ?></span></div>
                        <h4 class="title"><?php echo e($offer->package->{'name_' . App::getLocale()}); ?></h4>
                        <div class="price-wrapper">
                            <p class="price">
                                <sub class="before"><?php echo e($offer->package->price); ?></sub>
                                <span><?php echo e($offer->package->price - $offer->discount_amount); ?></span>
                                <sub>€</sub>
                            </p>
                        </div>
                        <ul class="features">
                            <?php echo $offer->package->{'notes_' . App::getLocale()}; ?>

                        </ul>
                        <a class="btn"
                            href="<?php echo e(route('purchasePackage', ['offer', $offer->id])); ?>"><?php echo e(trans('messages.Start now')); ?></a>
                    </div>
                <?php else: ?>
                    <div class="package-wrapper animate__animated animate__zoomIn">
                        <h4 class="title"><?php echo e($offer->package->{'name_' . App::getLocale()}); ?></h4>
                        <div class="price-wrapper">
                            <p class="price">
                                <sub class="before"><?php echo e($offer->package->price); ?></sub>
                                <span><?php echo e($offer->package->price - $offer->discount_amount); ?></span>
                                <sub>€</sub>
                            </p>
                        </div>
                        <ul class="features">
                            <?php echo $offer->package->{'notes_' . App::getLocale()}; ?>

                        </ul>
                        <a href="<?php echo e(route('purchasePackage', ['offer', $offer->id])); ?>"
                            class="btn"><?php echo e(trans('messages.Start now')); ?></a>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <h3><?php echo e(trans('messages.No Offers')); ?></h3>
            <?php endif; ?>
        </div>
        <div class="row more-btn-row">
            <a href="<?php echo e(route('packages')); ?>" class="btn">
                <?php echo e(trans('messages.View all offers and packages')); ?>

            </a>
        </div>
    </section>
    <section class="container-fluid counter-section">
        <div class="container">
            <div class="row">
                <div class="col-lg-3 col-md-3 col-sm-12 counter-item">
                    <h2 data-max="<?php echo e($examCount); ?>"> </h2><span>+</span>
                    <p class="text"><?php echo e(trans('messages.Exam')); ?></p>
                </div>
                <div class="col-lg-3 col-md-3 col-sm-12 counter-item">
                    <h2 data-max="<?php echo e($packageCount); ?>"> </h2><span>+</span>
                    <p class="text"><?php echo e(trans('messages.Package')); ?></p>
                </div>
                <div class="col-lg-3 col-md-3 col-sm-12 counter-item">
                    <h2 data-max="<?php echo e($questionCount); ?>"> </h2><span>+</span>
                    <p class="text"><?php echo e(trans('messages.Question')); ?></p>
                </div>
                <div class="col-lg-3 col-md-3 col-sm-12 counter-item">
                    <h2 data-max="<?php echo e($clientCount); ?>"></h2><span>+</span>
                    <p class="text"><?php echo e(trans('messages.Trainee')); ?></p>
                </div>
            </div>
        </div>
    </section>
    <section class="container why-section">
        <div class="row">
            <div class="col-lg-7 col-md-7 col-sm-12 content-wrapper">
                <h1 class="title">
                    <?php echo e(trans('messages.Why do you choose to train for the driving test with Adnan Al-Taher?')); ?>

                </h1>
                <p class="desc">
                    <?php echo e($settings->{'why_eltaher_desc_' . App::getLocale()}); ?>

                </p>
                <div class="row items-wrapper">
                    <div class="col-lg-6 col-md-12 item">
                        <div class="icon-wrapper">
                            <img src="<?php echo e(url('front_them/assets/imgs/tests-icon.png')); ?>" alt="">
                        </div>
                        <div class="data-wrapper">
                            <h6 class="head"><?php echo e($settings->{'why_eltaher_first_title_' . App::getLocale()}); ?></h6>
                            <p class="desc"><?php echo e($settings->{'why_eltaher_first_desc_' . App::getLocale()}); ?></p>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12 item">
                        <div class="icon-wrapper">
                            <img src="<?php echo e(url('front_them/assets/imgs/offers-icon.png')); ?>" alt="">
                        </div>
                        <div class="data-wrapper">
                            <h6 class="head"><?php echo e($settings->{'why_eltaher_secound_title_' . App::getLocale()}); ?></h6>
                            <p class="desc"><?php echo e($settings->{'why_eltaher_secound_desc_' . App::getLocale()}); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-5 col-md-5 col-sm-12 img-wrapper">
                <img src="<?php echo e(url('front_them/assets/imgs/why-section-img.png')); ?>" alt="">
            </div>
        </div>
    </section>
    <section class="container reserve-section">
        <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-12 content-wrapper">
                <h1 class="title"><?php echo e(trans('messages.Book a test drive now')); ?></h1>
                <p class="desc">
                    <?php echo e($settings->{'reserve_exam_desc_' . App::getLocale()}); ?>

                </p>
                <a href="<?php echo e(route('packages')); ?>" class="btn"><?php echo e(trans('messages.Book a test')); ?></a>
            </div>
            <div class="col-lg-6 col-md-6 col-sm-12 img-wrapper">
                <img src="<?php echo e(url('front_them/assets/imgs/reserve-img.png')); ?>" alt="">
            </div>
        </div>
    </section>
    <section class="container-fluid blog-section">
        <div class="container">
            <div class="row top-row text-center">
                <h1 class="title"><?php echo e(trans('messages.Articles and news')); ?></h1>
            </div>
            <div class="row blog-cards mt-5 mb-5">
                <?php $__empty_1 = true; $__currentLoopData = $homeBlog; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="col-lg-4 col-md-4 col-sm-12 wrapper">
                        <div class="news-card card">
                            <div class="blog-img-wrapper">
                                <img src="<?php echo e(url($blog->image)); ?>" alt="">
                                <div class="date">
                                    <span><?php echo e(time_elapsed_string(date('Y-m-d H:i', strtotime($blog->created_at)))); ?></span>
                                </div>
                            </div>
                            <div class="content-wrapper">
                                <h5 class="title"><?php echo e($blog->{'title_' . App::getLocale()}); ?></h5>
                                <p class="desc">
                                    <?php echo e($blog->{'description_' . App::getLocale()}); ?>

                                </p>
                            </div>
                            <a href="<?php echo e(route('article', $blog->{'slug_' . App::getLocale()})); ?>" class="btn">
                                <span><?php echo e(trans('messages.Read more')); ?></span>
                                <?php if(App::getLocale() == 'ar'): ?>
                                    <i class="fa-solid fa-angles-left"></i>
                                <?php else: ?>
                                    <i class="fa-solid fa-angles-right"></i>
                                <?php endif; ?>
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <?php endif; ?>
            </div>
            <div class="row more-btn-row">
                <a href="<?php echo e(route('blog', App\Models\BlogCategory::orderBy('arrangement', 'ASC')->first()->{'slug_' . App::getLocale()})); ?>"
                    class="btn">
                    <?php echo e(trans('messages.View all articles')); ?>

                </a>
            </div>
        </div>
    </section>
    <section class="container-fluid reviews-row">
        <div class="row top-row">
            <h1 class="title"><?php echo e(trans('messages.Opinions of our learners')); ?></h1>
        </div>
        <div class="row slider-row mt-1">
            <div class="swiper">
                <!-- Additional required wrapper -->
                <div class="swiper-wrapper">
                    <!-- Slides -->
                    <?php $__empty_1 = true; $__currentLoopData = $opinions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opinion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="swiper-slide">
                            <div class="text-wrapper">
                                <i class="fa-solid fa-quote-right"></i>
                                <p class="text">
                                    <?php echo e($opinion->opinion); ?>

                                </p>
                            </div>
                            <div class="user-info">

                                <div class="data">
                                    <p class="name"><?php echo e($opinion->client->name); ?></p>
                                    <p class="date">
                                        <?php echo e(time_elapsed_string(date('Y-m-d H:i', strtotime($opinion->created_at)))); ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <?php endif; ?>

                </div>
                <!-- If we need pagination -->
                <div class="swiper-pagination"></div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('site.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\eltaher\resources\views/site/home.blade.php ENDPATH**/ ?>