<?php $__env->startSection('content'); ?>
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> <?php echo e(trans('messages.Theory Package')); ?></h3>
            </div>

        </div>
    </div>
    <style>
        .offer-active {
            background-color: #FFF !important;
            border-color: #1221db !important;
            color: #0ee31e !important;
        }
    </style>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <div class="row">
                    <div class="col-4">
                        <div class="app-menu">
                            <div class="search-bx mx-5">
                                <form action="<?php echo e(route('theoryPackage.index')); ?>" method="GET">
                                    <div class="input-group">
                                        <input type="search" id="search" class="form-control" name="search"
                                            <?php if(isset($sort_search)): ?> value="<?php echo e($sort_search); ?>" <?php endif; ?>
                                            placeholder="<?php echo e(trans('messages.Title')); ?>" aria-label="Search"
                                            aria-describedby="button-addon2">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col" style="text-align: end">
                        <a href="<?php echo e(route('theoryPackage.create')); ?>"
                            class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                class="mdi mdi-plus"><span class="path1"></span><span class="path2"></span></span></a>

                    </div>
                </div>

            </div>
            <div class="box-body no-padding">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr class="">
                                <th class="text-center">
                                    #
                                </th>
                                <th class="text-center"><?php echo e(trans('messages.Name')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.photo_phone')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.photo_desktop')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Price')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Expiration duration')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Show in home')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Enabled')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Created')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Options')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center">
                                        <?php echo e($key + 1 + ($packages->currentPage() - 1) * $packages->perPage()); ?>

                                    </td>
                                    <td class="text-center"><?php echo e($package->{'name_' . App::getLocale()}); ?></td>
                                    <td>
                                        <?php if(!empty($package->photo_phone) && file_exists(public_path().'/'.$package->photo_phone)): ?>
                                            <div class="col-sm-6">
                                                <a class="image-popup-vertical-fit"
                                                   href="<?php echo e(url('/'.$package->photo_phone)); ?>">
                                                    <img
                                                        src="<?php echo e(url('/'.$package->photo_phone)); ?>"
                                                        class="img-fluid" alt=""/>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if(!empty($package->image) && file_exists(public_path().'/'.$package->image)): ?>
                                            <div class="col-sm-6">
                                                <a class="image-popup-vertical-fit"
                                                   href="<?php echo e(url('/'.$package->image)); ?>">
                                                    <img
                                                        src="<?php echo e(url('/'.$package->image)); ?>"
                                                        class="img-fluid" alt=""/>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center"><?php echo e($package->price); ?></td>
                                    <td class="text-center">
                                        <?php echo e($package->expiration_duration_in_dayes); ?>

                                        <?php echo e(trans('messages.Day')); ?>

                                    </td>
                                    <td class="text-center">
                                        <div class="form-group">
                                            <div class="checkbox">
                                                <input type="checkbox" id="Checkbox_<?php echo e($key); ?>"
                                                    <?php if ($package->show_in_home == 1) {
                                                        echo 'checked';
                                                    } ?> onchange="update_home(this)"
                                                    value="<?php echo e($package->id); ?>" />
                                                <label for="Checkbox_<?php echo e($key); ?>"></label>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <div class="form-group">
                                            <div class="checkbox">
                                                <input type="checkbox" id="Checkboxen_<?php echo e($key); ?>"
                                                    <?php if ($package->enable == 1) {
                                                        echo 'checked';
                                                    } ?> onchange="update_enabel(this)"
                                                    value="<?php echo e($package->id); ?>" />
                                                <label for="Checkboxen_<?php echo e($key); ?>"></label>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="text-center"><?php echo e($package->created_at); ?></td>
                                    <td class="text-center">
                                        <form action="<?php echo e(route('theoryPackage.destroy', $package->id)); ?>" method="Post"
                                            id="destroy-form-<?php echo e($package->id); ?>">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                        </form>
                                        <a href="<?php echo e(route('theoryPackage.show', $package->id)); ?>"
                                            class="waves-effect waves-light btn btn-primary-light btn-circle mx-5"><span
                                                class="mdi mdi-magnify"><span class="path1"></span><span
                                                    class="path2"></span></span></a>
                                        <a href="<?php echo e(route('theoryPackage.edit', $package->id)); ?>"
                                            class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                class="icon-Write"><span class="path1"></span><span
                                                    class="path2"></span></span></a>
                                        <a data-title="<?php echo e(trans('messages.Are you sure?')); ?>"
                                            data-no="<?php echo e(trans('messages.Cancel')); ?>"
                                            data-yes="<?php echo e(trans('messages.Yes, delete it!')); ?>"
                                            data-desc="<?php echo e(trans('messages.You will not be able to recover this!')); ?>"
                                            href="#" data-href="<?php echo e($package->id); ?>"
                                            class="sa-warning waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                class="icon-Trash1"><span class="path1"></span><span
                                                    class="path2"></span></span></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php echo $packages->withQueryString()->links('pagination::bootstrap-4'); ?>


                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
    <div class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
        id="make-offer" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">

            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        function update_enabel(el) {
            if (el.checked) {
                var enable = 1;
            } else {
                var enable = 0;
            }
            $.post(`<?php echo e(route('theoryPackage.updateEnabel')); ?>`, {
                _token: '<?php echo e(csrf_token()); ?>',
                id: el.value,
                enable: enable
            }, function(data) {

            });
        }

        function update_home(el) {
            if (el.checked) {
                var show_in_home = 1;
            } else {
                var show_in_home = 0;
            }
            $.post(`<?php echo e(route('theoryPackage.updateShowHome')); ?>`, {
                _token: '<?php echo e(csrf_token()); ?>',
                id: el.value,
                show_in_home: show_in_home
            }, function(data) {

            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/aatheorie.nl/httpdocs/resources/views/admin/TheoryPackage/index.blade.php ENDPATH**/ ?>