<div class="container nav-bar-container pt-2">
    <nav class="d-flex flex-wrap align-items-center justify-content-lg-start navbar navbar-expand-lg">
        <a href="<?php echo e(route('home')); ?>" class="d-flex logo align-items-center mb-2 mb-lg-0 text-dark text-decoration-none">
            <img src="<?php echo e(url('front_them/assets/imgs/small-logo.png')); ?>" alt="">
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"
            aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <i class="fa-solid fa-bars"></i>
        </button>
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <ul class="nav navbar-nav col-12 col-lg-auto ms-lg-auto mb-2 justify-content-center mb-md-0">
                <li><a href="<?php echo e(route('home')); ?>"
                        class="nav-link <?php echo e(Route::currentRouteName() == 'home' ? 'active' : ''); ?>  px-3 pb-0 link-dark"><?php echo e(trans('messages.Home')); ?></a>
                </li>
                <li><a href="<?php echo e(route('packages')); ?>"
                        class="nav-link <?php echo e(Route::currentRouteName() == 'packages' ? 'active' : ''); ?> px-3 pb-0 link-dark"><?php echo e(trans('messages.Packages and offers')); ?></a>
                </li>
                <li><a href="<?php echo e(route('exams')); ?>"
                        class="nav-link <?php echo e(Route::currentRouteName() == 'exams' ? 'active' : ''); ?> px-3 pb-0 link-dark"><?php echo e(trans('messages.Exams')); ?></a>
                </li>
                <li><a href="<?php echo e(route('blog', App\Models\BlogCategory::orderBy('arrangement', 'ASC')->first()->{'slug_' . App::getLocale()})); ?>"
                        class="nav-link <?php echo e(Route::currentRouteName() == 'blog' || Route::currentRouteName() == 'article' ? 'active' : ''); ?> px-3 pb-0 link-dark"><?php echo e(trans('messages.Blog')); ?></a>
                </li>
                <li><a href="<?php echo e(route('contactUs')); ?>"
                        class="nav-link <?php echo e(Route::currentRouteName() == 'contactUs' ? 'active' : ''); ?> px-3 pb-0 link-dark"><?php echo e(trans('messages.Contact us')); ?></a>
                </li>
            </ul>
            <div class="btns-wrapper text-end">
                <?php if(auth()->guard()->guest()): ?>
                    <?php if(Route::has('login')): ?>
                        <a href="<?php echo e(route('login')); ?>" class="btn login-btn mx-2"><?php echo e(trans('messages.Login')); ?></a>
                    <?php endif; ?>
                <?php else: ?>
                    <a href="#" class="link-dark text-decoration-none dropdown-toggle" data-bs-toggle="dropdown"
                        aria-expanded="false">
                        <?php echo e(trans('messages.My account')); ?>

                    </a>
                    <ul class="dropdown-menu text-small  mx-2">
                        <li><a class="dropdown-item" href="<?php echo e(route('account')); ?>"><?php echo e(Auth::user()->name); ?></a></li>
                        <li><a id="logout-click-button" class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                onclick="event.preventDefault();
                            document.getElementById('logout-form').submit();"><?php echo e(trans('messages.Logout')); ?>

                            </a>

                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                <?php echo csrf_field(); ?>
                            </form>
                        </li>
                    </ul>
                <?php endif; ?>
            </div>
        </div>
    </nav>
</div><?php /**PATH /var/www/vhosts/aatheorie.nl/demo.aatheorie.nl/resources/views/site/includes/navbar.blade.php ENDPATH**/ ?>