
<?php $__env->startSection('meta_title'); ?><?php echo e(trans('messages.Adnan Eltaher') . ' | ' . trans('messages.Exams')); ?><?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="container-fluid tests-page-wrapper">
        <div class="container">
            <div class="row title-row mb-5 text-center">
                <h1 class=" title "><?php echo e(trans('messages.Theory driving tests')); ?></h1>
                <p class="desc">
                    <?php echo e($setting->exam_header_description); ?>

                </p>
                <?php if(auth()->guard()->guest()): ?>
                <?php else: ?>
                    <div class="progress-card">
                        <div class="progress-wrapper">
                            <span class="progress-amount">%100</span>
                            <img src="<?php echo e(url('front_them/assets/imgs/progress-img.png')); ?>" alt="">
                            <button class="btn" data-bs-toggle="modal" data-bs-target="#progress-modal">
                                <?php echo e(trans('messages.See your progress here')); ?>

                            </button>
                        </div>

                    </div>
                <?php endif; ?>
            </div>
            <div class="row mt-3 mb-5 info-row ">
                <div class="texts-section-wrapper">
                    <button class="btn" data-bs-toggle="modal" data-bs-target="#symbols-modal">
                        <i class="fa-solid fa-circle-question"></i>
                        <span><?php echo e(trans('messages.The meaning of the symbols')); ?></span>
                    </button>
                    <button class="btn" data-bs-toggle="modal" data-bs-target="#test-info-modal">
                        <i class="fa-solid fa-circle-info"></i>
                        <span><?php echo e(trans('messages.Information about the theory test')); ?></span>
                    </button>
                    <?php if(auth()->guard()->guest()): ?>
                    <?php else: ?>
                        
                    <?php endif; ?>

                </div>
                <div class="layout-section">
                    <button class="btn" id="grid-btn">
                        <img src="<?php echo e(url('front_them/assets/imgs/grid.png')); ?>" alt="">
                    </button>
                    <button class="btn" id="lines-btn">
                        <img src="<?php echo e(url('front_them/assets/imgs/lines.png')); ?>" alt="">
                    </button>
                </div>
            </div>
            <?php if(session('error')): ?>
                <div class="alert alert-danger text-center">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            <div class="row tests-cards-wrapper">
                <?php $__empty_1 = true; $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="col-lg-4 col-md-6 col-sm-12 test-card">
                        <div class="test-long-wrapper">
                            <a href="<?php echo e(route('examInfo', $exam->id)); ?>" class="info" style="text-decoration: none">
                                
                                <p class="name"><?php echo e($exam->{'name_' . App::getLocale()}); ?></p>
                                <?php if(App\Models\Setting::select('test_exam_id')->find(1)->test_exam_id == $exam->id): ?>
                                    (<span style="color: red;font-size: small"><?php echo e(trans('messages.test')); ?></span>)
                                <?php else: ?>
                                <?php endif; ?>
                            </a>
                            <div class="actions">
                                <?php if(auth()->guard()->guest()): ?>
                                <?php else: ?>
                                    <div class="btn" onclick="getExamHistory(<?php echo e($exam->id); ?>)">
                                        <img src="<?php echo e(url('front_them/assets/imgs/repeate-icon.png')); ?>" alt="">
                                    </div>
                                <?php endif; ?>

                                <div class="btn info-btn" onclick="openExamInfoModel(<?php echo e($exam->id); ?>)">
                                    <img src="<?php echo e(url('front_them/assets/imgs/info-icon.png')); ?>" alt="">
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <h3><?php echo e(trans('messages.No Exams')); ?></h3>
                <?php endif; ?>

            </div>
        </div>
    </section>
    <!-- Symbols Modal -->
    <div class="modal fade symbols-modal" id="symbols-modal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="close-btn">
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"
                        style="all: unset; font-size: 1.5em; color: #1ba9ff;cursor: pointer;padding: .5em">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="head">
                        <i class="fa-solid fa-circle-question"></i>
                        <h2 class="title"><?php echo e(trans('messages.The meaning of the symbols')); ?></h2>
                    </div>
                    <div class="content">
                        <div class="accordion" id="accordionExample">
                            <?php $__empty_1 = true; $__currentLoopData = $sympol; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $symp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="heading<?php echo e($key); ?>">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapse<?php echo e($key); ?>" aria-expanded="true"
                                            aria-controls="collapse<?php echo e($key); ?>">
                                            <img src="<?php echo e(url('front_them/assets/imgs/symbols-icon-1.png')); ?>"
                                                alt="">
                                            <span><?php echo e($symp->{'question_' . App::getLocale()}); ?></span>
                                        </button>
                                    </h2>
                                    <div id="collapse<?php echo e($key); ?>" class="accordion-collapse collapse"
                                        aria-labelledby="heading<?php echo e($key); ?>" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <?php echo $symp->{'answer_' . App::getLocale()}; ?></div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php endif; ?>
                        </div>
                        <div class="btn-row">
                            <button class="btn"
                                data-bs-dismiss="modal"><?php echo e(trans('messages.Back to the tests')); ?></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Info Modal -->
    <div class="modal fade exam-info-modal" id="exam-info-modal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="close-btn">
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"
                        style="all: unset; font-size: 1.5em; color: #1ba9ff;cursor: pointer;padding: .5em">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="head">
                        <h2 class="title text-center"><?php echo e(trans('messages.Exam Info')); ?></h2>
                        <br>
                        <hr>
                        <br>
                    </div>
                    <div class="content">
                        <p class="desc" id="examinfop">

                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Test Info Modal -->
    <div class="modal fade test-info-modal" id="test-info-modal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="close-btn">
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"
                        style="all: unset; font-size: 1.5em; color: #1ba9ff;cursor: pointer;padding: .5em">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="head">
                        <i class="fa-solid fa-circle-info"></i>
                        <h2 class="title"><?php echo e(trans('messages.Information about the theory test')); ?></h2>
                    </div>
                    <div class="content">
                        <div class="accordion" id="accordionExample">

                            <?php $__empty_1 = true; $__currentLoopData = $theory_info; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $theory_in): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="heading<?php echo e($key); ?>">
                                        <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#collapse<?php echo e($key); ?>"
                                            aria-expanded="true" aria-controls="collapse<?php echo e($key); ?>">
                                            <img src="<?php echo e(url('front_them/assets/imgs/symbols-icon-1.png')); ?>"
                                                alt="">
                                            <span><?php echo e($theory_in->{'question_' . App::getLocale()}); ?></span>
                                        </button>
                                    </h2>
                                    <div id="collapse<?php echo e($key); ?>" class="accordion-collapse collapse"
                                        aria-labelledby="heading<?php echo e($key); ?>" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <?php echo $theory_in->{'answer_' . App::getLocale()}; ?></div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- History Modal -->
    <div class="modal fade test-history-modal" id="test-history-modal" tabindex="-1"
        aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="close-btn">
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"
                        style="all: unset; font-size: 1.5em; color: #1ba9ff;cursor: pointer;padding: .5em">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="head">
                        <img src="<?php echo e(url('front_them/assets/imgs/test-history-icon.png')); ?>" alt="">
                        <h2 class="title"><?php echo e(trans('messages.Record your previous exams')); ?></h2>
                    </div>
                    <div class="content" id="test-history-modal-content">

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Settings Modal -->
    <?php if(auth()->guard()->guest()): ?>
    <?php else: ?>
        <!-- Progress Modal -->
        <div class="modal fade progress-modal" id="progress-modal" tabindex="-1" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="close-btn">
                        <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close"
                            style="all: unset; font-size: 1.5em; color: #1ba9ff;cursor: pointer;padding: .5em">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="head">
                            <img src="<?php echo e(url('front_them/assets/imgs/track-progress-img.png')); ?>" alt="">
                            <h2 class="title"><?php echo e(trans('messages.Your progress in the tests')); ?></h2>
                            <p class="desc">
                                <?php echo e(trans('messages.The more correct answers, the higher the progress')); ?></p>
                        </div>
                        <div class="content">
                            <div class="table-responsive">
                                <table class="table table-striped table-hover">
                                    <thead>
                                        <th scope="col">
                                            <i class="fa-solid fa-book-open"></i>
                                            <span><?php echo e(trans('messages.Test subject')); ?></span>
                                        </th>
                                        <th scope="col">
                                            <i class="fa-solid fa-file"></i>
                                            <span><?php echo e(trans('messages.The result')); ?></span>
                                        </th>
                                        <th scope="col">
                                            <i class="fa-solid fa-chart-line"></i>
                                            <span><?php echo e(trans('messages.progress')); ?></span>
                                        </th>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td scope="row"><?php echo e($item->exam->{'name_' . App::getLocale()}); ?></td>
                                                <td><?php echo e($item->score); ?></td>
                                                <td>
                                                    <div class="progress" style="height: 20px;">
                                                        <div class="progress-bar" role="progressbar"
                                                            aria-label="Example with label"
                                                            style="width: <?php echo e($item->score); ?>%;"
                                                            aria-valuenow="<?php echo e($item->score); ?>" aria-valuemin="0"
                                                            aria-valuemax="100"><?php echo e($item->score); ?>%</div>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <?php endif; ?>



                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $('.test-history-modal').click(function() {
            $('#test-history-modal').modal('show');
        })

        function openExamInfoModel(id) {
            $.post(`<?php echo e(route('exam.getInfo')); ?>`, {
                    _token: '<?php echo e(csrf_token()); ?>',
                    id: id
                },
                function(data) {
                    $('#examinfop').html(data);
                    $('#exam-info-modal').modal('show');
                });

        }

        function getExamHistory(id) {
            $.post(`<?php echo e(route('exam.getExamHistory')); ?>`, {
                    _token: '<?php echo e(csrf_token()); ?>',
                    id: id
                },
                function(data) {
                    $('#test-history-modal-content').html(data);
                    $('#test-history-modal').modal('show');
                });
        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('site.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/aatheorie.nl/demo.aatheorie.nl/resources/views/site/exams.blade.php ENDPATH**/ ?>