<?php $__env->startSection('content'); ?>
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> <?php echo e(trans('messages.Youtube Videos')); ?></h3>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <div class="row">
                    <div class="col-4">
                        <div class="app-menu">
                            <div class="search-bx mx-5">
                                <form action="<?php echo e(route('youtubVideos.index')); ?>" method="GET">
                                    <div class="input-group">
                                        <input type="search" id="search" class="form-control" name="search"
                                               <?php if(isset($sort_search)): ?> value="<?php echo e($sort_search); ?>" <?php endif; ?>
                                               placeholder="<?php echo e(trans('messages.Title')); ?>" aria-label="Search"
                                               aria-describedby="button-addon2">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col" style="text-align: end">
                        <a href="<?php echo e(route('video.addView')); ?>"
                           class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                class="mdi mdi-plus"><span class="path1"></span><span class="path2"></span></span></a>
                    </div>
                </div>

            </div>
            <div class="box-body no-padding">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                        <tr class="">
                            <th class="text-center">
                                #
                            </th>
                            <th class="text-center"><?php echo e(trans('messages.Title')); ?></th>
                            <th class="text-center"><?php echo e(trans('messages.Link_ar')); ?></th>
                            <th class="text-center"><?php echo e(trans('messages.Link_en')); ?></th>
                            <th class="text-center"><?php echo e(trans('messages.Link_nl')); ?></th>
                            <th class="text-center"><?php echo e(trans('messages.Enabled')); ?></th>
                            <th class="text-center"><?php echo e(trans('messages.countView')); ?></th>
                            <th class="text-center"><?php echo e(trans('messages.Created')); ?></th>
                            <th class="text-center"><?php echo e(trans('messages.Options')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="text-center">
                                    <?php echo e($key + 1 + ($videos->currentPage() - 1) * $videos->perPage()); ?>

                                </td>
                                <td class="text-center"><?php echo e($video->{'name_' . App::getLocale()}); ?></td>
                                <td class="text-center"><a href="https://vimeo.com/<?php echo e($video->url_ar); ?>" target="blank"><i
                                            class="fa fa-link" style="font-size: 1.5em"></i></a></td>
                                <td class="text-center"><a href="https://vimeo.com/<?php echo e($video->url_en); ?>" target="blank"><i
                                            class="fa fa-link" style="font-size: 1.5em"></i></a></td>
                                <td class="text-center"><a href="https://vimeo.com/<?php echo e($video->url_nl); ?>" target="blank"><i
                                            class="fa fa-link" style="font-size: 1.5em"></i></a></td>
                                <td class="text-center">
                                    <div class="form-group">
                                        <div class="checkbox">
                                            <input type="checkbox" id="Checkbox_<?php echo e($key); ?>"
                                                   <?php if ($video->is_active == 1) {
                                                       echo 'checked';
                                                   } ?> onchange="update_enabel(this)"
                                                   value="<?php echo e($video->id); ?>" />
                                            <label for="Checkbox_<?php echo e($key); ?>"></label>
                                        </div>
                                    </div>
                                </td>

                                <td class="text-center"><?php echo e($video->videoShows != null ? $video->videoShows->sum('count_watch')  :0); ?></td>
                                <td class="text-center"><?php echo e($video->created_at); ?></td>
                                <td class="text-center">
                                    <form action="<?php echo e(route('video.destroy', $video->id)); ?>" method="Post"
                                          id="destroy-form-<?php echo e($video->id); ?>">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                    </form>
                                    <a href="<?php echo e(route('video.updatedView', $video->id)); ?>"
                                       class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                            class="icon-Write"><span class="path1"></span><span
                                                class="path2"></span></span></a>
                                    <a data-title="<?php echo e(trans('messages.Are you sure?')); ?>"
                                       data-no="<?php echo e(trans('messages.Cancel')); ?>"
                                       data-yes="<?php echo e(trans('messages.Yes, delete it!')); ?>"
                                       data-desc="<?php echo e(trans('messages.You will not be able to recover this!')); ?>"
                                       href="#" data-href="<?php echo e($video->id); ?>"
                                       class="sa-warning waves-effect waves-light btn btn-primary-light btn-circle"><span
                                            class="icon-Trash1"><span class="path1"></span><span
                                                class="path2"></span></span></a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                    <?php echo $videos->withQueryString()->links('pagination::bootstrap-4'); ?>


                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-company">

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        function update_enabel(el) {
            if (el.checked) {
                var enabel = 1;
            } else {
                var enabel = 0;
            }
            $.post(`<?php echo e(route('video.changeStatus')); ?>`, {
                _token: '<?php echo e(csrf_token()); ?>',
                id: el.value,
                enabel: enabel
            }, function(data) {

            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\localhost\htdocs\newTaher\resources\views/admin/videos/index.blade.php ENDPATH**/ ?>