<?php
    $footer_data = App\Models\Setting::select('footer_desc_' . App::getLocale() . ' as footer_desc', 'address_' . App::getLocale() . ' as address', 'main_phone', 'secoundry_phone', 'email', 'facebook', 'tweeter', 'whatsapp', 'youyube', 'lat', 'lon')->find(1);
?>
<footer class="container-fluid">
    <div class="container">
        <div class="row">
            <div class="col-lg-4 col-md-3 col-sm-12 info-wrapper">
                <img src="<?php echo e(url('front_them/assets/imgs/logo.png')); ?>" alt="" class="logo">
                <p class="desc">
                    <?php echo e($footer_data->footer_desc); ?>

                </p>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-12 links-wrapper">
                <a href="<?php echo e(route('packages')); ?>" class="link">
                    <?php if(App::getLocale() == 'ar'): ?>
                        <i class="fa-solid fa-angles-left"></i>
                    <?php else: ?>
                        <i class="fa-solid fa-angles-right"></i>
                    <?php endif; ?>
                    <span><?php echo e(trans('messages.Packages and offers')); ?></span>
                </a>
                <a href="<?php echo e(route('faq')); ?>" class="link">
                    <?php if(App::getLocale() == 'ar'): ?>
                        <i class="fa-solid fa-angles-left"></i>
                    <?php else: ?>
                        <i class="fa-solid fa-angles-right"></i>
                    <?php endif; ?>
                    <span><?php echo e(trans('messages.FAQ')); ?></span>
                </a>
                <a href="<?php echo e(route('blog', App\Models\BlogCategory::orderBy('arrangement', 'ASC')->first()->{'slug_' . App::getLocale()})); ?>"
                    class="link">
                    <?php if(App::getLocale() == 'ar'): ?>
                        <i class="fa-solid fa-angles-left"></i>
                    <?php else: ?>
                        <i class="fa-solid fa-angles-right"></i>
                    <?php endif; ?>
                    <span><?php echo e(trans('messages.Blog')); ?></span>
                </a>
                <a href="<?php echo e(route('contactUs')); ?>" class="link">
                    <?php if(App::getLocale() == 'ar'): ?>
                        <i class="fa-solid fa-angles-left"></i>
                    <?php else: ?>
                        <i class="fa-solid fa-angles-right"></i>
                    <?php endif; ?>
                    <span><?php echo e(trans('messages.Contact us')); ?></span>
                </a>
                <?php $__currentLoopData = App\Models\Page::where('enabel', true)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(url('/', [$page->{'slug_' . App::getLocale()}])); ?>" class="link">
                        <?php if(App::getLocale() == 'ar'): ?>
                            <i class="fa-solid fa-angles-left"></i>
                        <?php else: ?>
                            <i class="fa-solid fa-angles-right"></i>
                        <?php endif; ?>
                        <span><?php echo e($page->{'title_' . App::getLocale()}); ?></span>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-12 contact-info-wrapper">
                <div class="info-item">
                    <i class="fa-solid fa-phone"></i>
                    <a href="tel:+2001098765432"><?php echo e($footer_data->main_phone); ?></a> -
                    <a href="tel:+2001098765432"><?php echo e($footer_data->secoundry_phone); ?></a>
                </div>
                <div class="info-item">
                    <i class="fa-solid fa-envelope"></i>
                    <a href="mailto:mail@email.com"><?php echo e($footer_data->email); ?></a>
                </div>
                <div class="info-item">
                    <i class="fa-solid fa-location-dot"></i>
                    <span> <?php echo e($footer_data->address); ?></span>
                </div>
            </div>
        </div>
        <div class="row copyrights-row">
            <div class="col-lg-6 col-md-6 col-sm-12 social-links">
                <a href="<?php echo e($footer_data->facebook); ?>" class="social-link" target="blank"><i
                        class="fa-brands fa-facebook-f"></i></a>
                <a href="<?php echo e($footer_data->youyube); ?>" class="social-link" target="blank"><i
                        class="fa-brands fa-youtube"></i></a>
                <a href="<?php echo e('https://www.google.com/maps/@' . $footer_data->lat . ',' . $footer_data->lon . ',15z'); ?>"
                    class="social-link" target="blank"><i class="fa-solid fa-location-dot"></i></a>
                <a href="<?php echo e($footer_data->whatsapp); ?>" class="social-link" target="blank"><i
                        class="fa-brands fa-whatsapp"></i></a>
            </div>
            <div class="col-lg-6 col-md-6 col-sm-12 copyrights-text">
                <p><?php echo e(trans('messages.All rights reserved to Semicolon-Ltd Software Co.')); ?></p>
            </div>
        </div>
    </div>
</footer>
<?php /**PATH /var/www/vhosts/aatheorie.nl/demo.aatheorie.nl/resources/views/site/includes/footer.blade.php ENDPATH**/ ?>