<?php $__env->startSection('content'); ?>
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"><?php echo e(trans('messages.Create Subscribtion')); ?></h3>
            </div>

        </div>
    </div>

    <style>
        .bootstrap-tagsinput {
            width: 100%;
            padding: 0.6em;
        }
    </style>
    <!-- Main content -->

    <section class="content">
        <?php echo Form::open(['route' => 'subscription.store', 'files' => true, 'id' => 'add-subscription-form']); ?>

        <div class="row">
            <div class="col-lg-8 mx-auto">

                <div class="box">
                    <div class="box-body">
                        <div class="form-group">
                            <label for="name"><?php echo e(trans('messages.Clients')); ?>

                            </label>
                          
                            <select class="select2" id="user_id" name="user_id" style="width: 100%"></select>
                        </div>
                        <div class="row">
                            <div class="col-md">
                                <div class="form-group">
                                    <label for="name"><?php echo e(trans('messages.Package')); ?>

                                    </label>
                                    <div>
                                        <?php echo Form::select('package_id', $packages, null, [
                                            'class' => 'form-control',
                                            'id' => 'package_id',
                                            'data-placeholder' => trans('Package'),

                                        ]); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="col-md">
                                <div class="form-group" id="offer_id_cont">
                                    <label for="name"><?php echo e(trans('messages.Offer')); ?>

                                    </label>
                                    <div>
                                        <?php echo Form::select('offer_id', $offers, null, [
                                            'placeholder' => trans('messages.Choose Offer'),
                                            'class' => 'form-control',
                                            'id' => 'offer_id',
                                            'onchange' => 'getOfferDiscount(this)',
                                            'data-placeholder' => trans('Offer'),
                                        ]); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md">
                                <div class="form-group" style="padding: 1em;">
                                    <label for="price"><?php echo e(trans('messages.Price')); ?>

                                    </label>
                                    <div>
                                        <?php echo Form::number('price', 0, [
                                            'class' => 'form-control',
                                            'id' => 'price',
                                            'placeholder' => trans('messages.Price'),
                                        ]); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="col-md">
                                <div class="form-group" style="padding: 1em;">
                                    <label for="offer_discount"><?php echo e(trans('messages.Discount amount')); ?>

                                    </label>
                                    <div>
                                        <?php echo Form::number('offer_discount', 0, [
                                            'class' => 'form-control',
                                            'id' => 'offer_discount',
                                            'placeholder' => trans('messages.Discount amount'),
                                        ]); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md">
                                <div class="form-group" style="padding: 1em;">
                                    <label for="subscription_date"><?php echo e(trans('messages.Subscription date')); ?>

                                    </label>
                                    <div>
                                        <?php echo Form::datetimeLocal('subscription_date', null, [
                                            'class' => 'form-control',
                                            'placeholder' => trans('messages.Start date'),
                                        ]); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="col-md">
                                <div class="form-group" style="padding: 1em;">
                                    <label for="expiration_date"><?php echo e(trans('messages.Expiration date')); ?>

                                    </label>
                                    <div>
                                        <?php echo Form::datetimeLocal('expiration_date', null, [
                                            'class' => 'form-control',
                                            'placeholder' => trans('messages.Expiration date'),
                                        ]); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.box-body -->
                    <div class="box-footer">
                        <button type="submit" class="btn btn-rounded btn-primary btn-outline">
                            <i class="ti-save-alt"></i> <?php echo e(trans('messages.Save')); ?>

                        </button>
                    </div>
                </div>
            </div>
        </div>
        <?php echo Form::Close(); ?>

    </section>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        var userId = '<?php echo e($user_id); ?>';
        $('.select2').select2({
            placeholder: 'Search for a Client',
            ajax: {
                url: '<?php echo e(route('userSubscrib.search')); ?>',
                type: 'POST',
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return {
                        _token: '<?php echo e(csrf_token()); ?>',
                        search: params.term,
                    };
                },
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: true
            }
        });
        if(userId != null)
        {
                $.ajax({
                    url: '<?php echo e(route('userSubscrib.getUser')); ?>', // Create a route to get the user by ID
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        user_id: userId
                    },
                    success: function(data) {
                        // Create a new option and append it to the select
                        var option = new Option(data.text, data.id, true, true);
                        $('.select2').append(option).trigger('change');
                    }
                });
        }

        alert($(this).val());
        $.post(`<?php echo e(route('package.getPackageOffers')); ?>`, {
            _token: '<?php echo e(csrf_token()); ?>',
            id: $(this).val()
        }, function(data) {
            $("#offer_id_cont").html(data);
        });

        $.post(`<?php echo e(route('package.getPackagePrice')); ?>`, {
            _token: '<?php echo e(csrf_token()); ?>',
            id: $(this).val()
        }, function(data) {
            $("#price").val(data);
        });

        $('#package_id').change(function() {
            $.post(`<?php echo e(route('package.getPackageOffers')); ?>`, {
                _token: '<?php echo e(csrf_token()); ?>',
                id: $(this).val()
            }, function(data) {
                $("#offer_id_cont").html(data);
            });
            $.post(`<?php echo e(route('package.getPackagePrice')); ?>`, {
                _token: '<?php echo e(csrf_token()); ?>',
                id: $(this).val()
            }, function(data) {
                $("#price").val(data);
            });
        });

        function getOfferDiscount(v) {
            var offer_id = v.options[v.selectedIndex].value;
            if (offer_id != '') {
                $.post(`<?php echo e(route('offer.getOfferDiscount')); ?>`, {
                    _token: '<?php echo e(csrf_token()); ?>',
                    id: offer_id
                }, function(data) {
                    $("#offer_discount").val(data);
                });
            } else {
                $('#offer_discount').val(0);
            }
        }


    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/aatheorie.nl/httpdocs/resources/views/admin/Subscription/create.blade.php ENDPATH**/ ?>