
<?php $__env->startSection('content'); ?>
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> <?php echo e(trans('messages.Opinions')); ?></h3>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <div class="row">
                    <div class="col-4">
                        <div class="app-menu">
                            <div class="search-bx mx-5">
                                <form action="<?php echo e(route('opinion.index')); ?>" method="GET">
                                    <div class="input-group">
                                        <input type="search" id="search" class="form-control" name="search"
                                            <?php if(isset($sort_search)): ?> value="<?php echo e($sort_search); ?>" <?php endif; ?>
                                            placeholder="<?php echo e(trans('messages.Opinion')); ?>" aria-label="Search"
                                            aria-describedby="button-addon2">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col" style="text-align: end">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('opinion_create')): ?>
                            <a href="<?php echo e(route('opinion.create')); ?>"
                                class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                    class="mdi mdi-plus"><span class="path1"></span><span class="path2"></span></span></a>
                        <?php endif; ?>

                    </div>
                </div>

            </div>
            <div class="box-body no-padding">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr class="">
                                <th class="text-center">
                                    #
                                </th>
                                <th class="text-center"><?php echo e(trans('messages.Client')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Opinion')); ?></th>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('opinion_update')): ?>
                                    <th class="text-center"><?php echo e(trans('messages.Enabled')); ?></th>
                                <?php endif; ?>
                                <th class="text-center"><?php echo e(trans('messages.Created')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Options')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $opinions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $opinion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center">
                                        <?php echo e($key + 1 + ($opinions->currentPage() - 1) * $opinions->perPage()); ?>

                                    </td>
                                    <td class="text-center"><?php echo e($opinion->client->name); ?></td>
                                    <td class="text-center"><?php echo e($opinion->opinion); ?></td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('opinion_update')): ?>
                                        <td class="text-center">
                                            <div class="form-group">
                                                <div class="checkbox">
                                                    <input type="checkbox" id="Checkbox_<?php echo e($key); ?>"
                                                        <?php if ($opinion->enable == 1) {
                                                            echo 'checked';
                                                        } ?> onchange="update_enabel(this)"
                                                        value="<?php echo e($opinion->id); ?>" />
                                                    <label for="Checkbox_<?php echo e($key); ?>"></label>
                                                </div>
                                            </div>
                                        </td>
                                    <?php endif; ?>
                                    <td class="text-center"><?php echo e($opinion->created_at); ?></td>
                                    <td class="text-center">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('opinion_delete')): ?>
                                            <form action="<?php echo e(route('opinion.destroy', $opinion->id)); ?>" method="Post"
                                                id="destroy-form">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                            </form>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('opinion_update')): ?>
                                            <a href="<?php echo e(route('opinion.edit', $opinion->id)); ?>"
                                                class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                    class="icon-Write"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('opinion_delete')): ?>
                                            <a data-title="<?php echo e(trans('messages.Are you sure?')); ?>"
                                                data-no="<?php echo e(trans('messages.Cancel')); ?>"
                                                data-yes="<?php echo e(trans('messages.Yes, delete it!')); ?>"
                                                data-desc="<?php echo e(trans('messages.You will not be able to recover this!')); ?>"
                                                href="#" data-href="<?php echo e(route('opinion.destroy', $opinion->id)); ?>"
                                                class="sa-warning waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                    class="icon-Trash1"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                    <?php echo $opinions->withQueryString()->links('pagination::bootstrap-4'); ?>


                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-company">

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        function update_enabel(el) {
            if (el.checked) {
                var enable = 1;
            } else {
                var enable = 0;
            }
            $.post(`<?php echo e(route('opinion.updateEnabel')); ?>`, {
                _token: '<?php echo e(csrf_token()); ?>',
                id: el.value,
                enable: enable
            }, function(data) {

            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\eltaher\resources\views/admin/Opinion/index.blade.php ENDPATH**/ ?>