
<?php $__env->startSection('meta_title'); ?><?php echo e(trans('messages.Adnan Eltaher') . ' | ' . trans('messages.Packages & Offers')); ?><?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="packages-page-wrapper container">
        <div class="row top-row text-center">
            <h1 class="title"><?php echo e(trans('messages.Packages & Offers')); ?></h1>
            <div class="filter-btns mb-4">
                <button class="btn active" id="packages-btn">
                    <span>
                        <?php echo e(trans('messages.Packages')); ?>

                    </span>
                </button>
                <button class="btn" id="offers-btn">
                    <i class="fa-solid fa-certificate"></i>
                    <span><?php echo e(trans('messages.Offers')); ?></span>
                </button>
            </div>
        </div>
        <div class="row cards-row " id="packages-cards">
            <?php if(session('error')): ?>
                <div class="alert alert-danger" style="margin-bottom: 3em">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>
            <?php $__empty_1 = true; $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php if($package->{'badge_' . App::getLocale()}): ?>
                    <div class="package-wrapper active animate__animated animate__zoomIn">
                        <div class="ribbon"><span><?php echo e($package->{'badge_' . App::getLocale()}); ?></span></div>
                        <h4 class="title"><?php echo e($package->{'name_' . App::getLocale()}); ?></h4>
                        <div class="price-wrapper">
                            <p class="price">
                                <span><?php echo e($package->price); ?></span>
                                <sub>€</sub>
                            </p>
                        </div>
                        <ul class="features">
                            <?php echo $package->{'notes_' . App::getLocale()}; ?>

                        </ul>
                        <a href="<?php echo e(route('purchasePackage', ['package', $package->id])); ?>"
                            class="btn"><?php echo e(trans('messages.Start now')); ?></a>
                    </div>
                <?php else: ?>
                    <div class="package-wrapper animate__animated animate__zoomIn">
                        <h4 class="title"><?php echo e($package->{'name_' . App::getLocale()}); ?></h4>
                        <div class="price-wrapper">
                            <p class="price">
                                <span><?php echo e($package->price); ?></span>
                                <sub>€</sub>
                            </p>
                        </div>
                        <ul class="features">
                            <?php echo $package->{'notes_' . App::getLocale()}; ?>

                        </ul>
                        <a href="<?php echo e(route('purchasePackage', ['package', $package->id])); ?>"
                            class="btn"><?php echo e(trans('messages.Start now')); ?></a>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <h3><?php echo e(trans('messages.No Packages')); ?></h3>
            <?php endif; ?>
        </div>
        <div class="row cards-row" id="offers-cards">
            <?php if(session('error')): ?>
                <div class="alert alert-danger" style="margin-bottom: 3em">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            <?php $__empty_1 = true; $__currentLoopData = $offers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php if($offer->package->{'badge_' . App::getLocale()}): ?>
                    <div class="package-wrapper active animate__animated animate__zoomIn">
                        <div class="ribbon"><span><?php echo e($offer->package->{'badge_' . App::getLocale()}); ?></span></div>
                        <h4 class="title"><?php echo e($offer->package->{'name_' . App::getLocale()}); ?></h4>
                        <div class="price-wrapper">
                            <p class="price">
                                <sub class="before"><?php echo e($offer->package->price); ?></sub>
                                <span><?php echo e($offer->package->price - $offer->discount_amount); ?></span>
                                <sub>€</sub>
                            </p>
                        </div>
                        <ul class="features">
                            <?php echo $offer->package->{'notes_' . App::getLocale()}; ?>

                        </ul>
                        <a class="btn"
                            href="<?php echo e(route('purchasePackage', ['offer', $offer->id])); ?>"><?php echo e(trans('messages.Start now')); ?></a>
                    </div>
                <?php else: ?>
                    <div class="package-wrapper animate__animated animate__zoomIn">
                        <h4 class="title"><?php echo e($offer->package->{'name_' . App::getLocale()}); ?></h4>
                        <div class="price-wrapper">
                            <p class="price">
                                <sub class="before"><?php echo e($offer->package->price); ?></sub>
                                <span><?php echo e($offer->package->price - $offer->discount_amount); ?></span>
                                <sub>€</sub>
                            </p>
                        </div>
                        <ul class="features">
                            <?php echo $offer->package->{'notes_' . App::getLocale()}; ?>

                        </ul>
                        <a class="btn"
                            href="<?php echo e(route('purchasePackage', ['offer', $offer->id])); ?>"><?php echo e(trans('messages.Start now')); ?></a>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <h3><?php echo e(trans('messages.No Packages')); ?></h3>
            <?php endif; ?>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('site.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/aatheorie.nl/demo.aatheorie.nl/resources/views/site/packages.blade.php ENDPATH**/ ?>