<!DOCTYPE html>
<html lang="<?php echo e(App::getLocale()); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(trans('messages.Adnan Eltaher')); ?> | <?php echo e(trans('messages.Login')); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css"
        integrity="sha512-MV7K8+y+gLIBoVD59lQIYicR65iaqukzvf/nwasF0nqhPay5w/9lJmVM2hMDcnK1OnMGCdVK+iQrJ7lzPJQd1w=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat&family=Tajawal&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(url('front_them/assets/css/style_' . App::getLocale() . '.css')); ?>">
</head>

<body>
    <section class="container-fluid login-container">
        <div class="row">
            <div class="col-lg-1 col-md-0 col-sm-0"></div>
            <div class="col-lg-5 col-md-7 col-sm-12 login-form-wrapper">
                <div class="row top-nav-row">
                    <a href="<?php echo e(route('home')); ?>" class="back-link">
                        <i class="fa-sharp fa-solid fa-angle-right"></i>
                        <span><?php echo e(trans('messages.Back to home')); ?></span>
                    </a>
                </div>
                <div class="row logo mt-2 mb-5">
                    <img src="<?php echo e(url('front_them/assets/imgs/logo.png')); ?>" alt="logo image">
                </div>
                <div class="row head">
                    <h1><?php echo e(trans('messages.Login')); ?></h1>
                </div>
                <div class="row form-wrapper mt-3">
                    <form method="POST" action="<?php echo e(route('login')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="control-wrapper mb-3">
                            <label for="login-email" class="form-label"><?php echo e(trans('messages.Email')); ?></label>
                            <input type="email" class="form-control" name="email" id="login-email"
                                placeholder="name@example.com" required autocomplete="email" autofocus>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="error text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="control-wrapper mb-3">
                            <label for="login-password" class="form-label"><?php echo e(trans('messages.Password')); ?></label>
                            <div class="input-wrapper">
                                <input name="password" type="password" class="form-control" aria-describedby="icon"
                                    id="login-password" placeholder="******" required autocomplete="current-password">
                                <button class="btn" type="button" id="login-password-btn">
                                    <i class="fa-regular fa-eye" id="login-eye-icon"></i>
                                </button>
                            </div>
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="error text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="row-wrapper mb-3">
                            <div class="form-check">
                                <label class="container">
                                    <span class="text"><?php echo e(trans('messages.Remember Me')); ?></span>
                                    <input type="checkbox" checked="checked">
                                    <span class="checkmark"></span>
                                </label>
                            </div>
                            <div class="forget-link-wrapper">
                                <?php if(Route::has('password.request')): ?>
                                    <a
                                        href="<?php echo e(route('password.request')); ?>"><?php echo e(trans('messages.Forget password?')); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <button class="btn btn-block mt-4" type="submit"><?php echo e(trans('messages.Login')); ?></button>
                    </form>
                </div>
                <div class="row redirection-row mt-3">
                    <span><?php echo e(trans('messages.Dont have an account?')); ?></span>
                    <a href="<?php echo e(route('register')); ?>"><?php echo e(trans('messages.Create new account')); ?></a>
                </div>
            </div>
        </div>
    </section>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"
        integrity="sha384-7+zCNj/IqJ95wo16oMtfsKbZ9ccEh31eOz1HGyDuCQ6wgnyJNSYdrPa03rtR1zdB" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"
        integrity="sha384-QJHtvGhmr9XOIpI6YVutG+2QOK9T+ZnN4kzFN1RtK3zEFEIsxhlmWl5/YESvpZ13" crossorigin="anonymous">
    </script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.js"></script>
    <script src="<?php echo e(url('front_them/assets/js/index.js')); ?>"></script>
</body>

</html>
<?php /**PATH D:\xampp\htdocs\eltaher\resources\views/auth/login.blade.php ENDPATH**/ ?>