<?php $__env->startSection('content'); ?>
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> <?php echo e(trans('messages.Categories')); ?></h3>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <form action="<?php echo e(route('examCategory.index')); ?>" method="GET">

                    <div class="row">
                        <div class="col-3">
                            <div class="app-menu">
                                <div class="search-bx mx-5">

                                    <div class="input-group">
                                        <input type="search" id="search" class="form-control" name="search"
                                            <?php if(isset($sort_search)): ?> value="<?php echo e($sort_search); ?>" <?php endif; ?>
                                            placeholder="<?php echo e(trans('messages.Name')); ?>" aria-label="Search"
                                            aria-describedby="button-addon2">
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="col-3">
                            <select name="exam_id" id="exam-filter" class="select2 form-control">
                                <option value="0"><?php echo e(trans('messages.All')); ?></option>
                                <?php $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e($exam_id == $exam->id ? 'selected' : ''); ?> value="<?php echo e($exam->id); ?>">
                                        <?php echo e($exam->{'name_' . App::getLocale()}); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-3" style="position: relative">
                            <i class="fa fa-filter"
                                style="position: absolute;<?php echo e(App::getLocale() == 'ar' ? 'right' : 'left'); ?>:1em;font-size: 1.5em;line-height: 1.5em;color: #FFF"></i>
                            <input style="height: 2em;line-height: 1em;padding: 0em 2em" type="submit"
                                value="<?php echo e(trans('messages.Filter')); ?>" class="btn btn-primary">
                        </div>
                        <div class="col" style="text-align: end">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam_category_store')): ?>
                                <a href="<?php echo e(route('examCategory.create')); ?>"
                                    class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                        class="mdi mdi-plus"><span class="path1"></span><span class="path2"></span></span></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </form>
            </div>
            <div class="box-body no-padding">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr class="">
                                <th class="text-center">
                                    #
                                </th>
                                <th class="text-center"><?php echo e(trans('messages.Name')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Exam')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Questions')); ?></th>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam_category_update_Arrangment')): ?>
                                    <th class="text-center"><?php echo e(trans('messages.Arrangment')); ?></th>
                                <?php endif; ?>
                                <th class="text-center"><?php echo e(trans('messages.Wrong to fail')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Created')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Options')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center">
                                        <?php echo e($key + 1 + ($categories->currentPage() - 1) * $categories->perPage()); ?>

                                    </td>
                                    <td class="text-center"><?php echo e($category->{'name_' . App::getLocale()}); ?></td>
                                    <td class="text-center"><?php echo e($category->exam->{'name_' . App::getLocale()}); ?></td>
                                    <td class="text-center"><?php echo e($category->questions_num); ?>

                                        <?php echo e(trans('messages.Question')); ?></td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam_category_update_Arrangment')): ?>
                                        <td class="text-center">
                                            <div class="form-group">
                                                <input type="number" id="<?php echo e($category->id); ?>" class="form-control"
                                                    style="width: 50%;margin: auto;" onchange="updateArrangment(this)"
                                                    value="<?php echo e($category->arrangment); ?>" />
                                            </div>
                                        </td>
                                    <?php endif; ?>
                                    <td class="text-center"><?php echo e($category->wrong_question_to_fail); ?>

                                        <?php echo e(trans('messages.Question')); ?></td>
                                    <td class="text-center"><?php echo e($category->created_at); ?>

                                    <td class="text-center">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam_category_delete')): ?>
                                            <form action="<?php echo e(route('examCategory.destroy', $category->id)); ?>" method="Post"
                                                id="destroy-form-<?php echo e($category->id); ?>">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                            </form>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('question_list')): ?>
                                            <a title="<?php echo e(trans('messages.Category questions')); ?>"
                                                href="<?php echo e(route('question.index', ['exam_id' => $category->exam->id, 'category_id' => $category->id])); ?>"
                                                class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                    class="fa fa-question-circle-o"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam_category_edit')): ?>
                                            <a href="<?php echo e(route('examCategory.edit', $category->id)); ?>"
                                                class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                    class="icon-Write"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam_category_delete')): ?>
                                            <a data-title="<?php echo e(trans('messages.Are you sure?')); ?>"
                                                data-no="<?php echo e(trans('messages.Cancel')); ?>"
                                                data-yes="<?php echo e(trans('messages.Yes, delete it!')); ?>"
                                                data-desc="<?php echo e(trans('messages.You will not be able to recover this!')); ?>"
                                                href="#" data-href="<?php echo e($category->id); ?>"
                                                class="sa-warning waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                    class="icon-Trash1"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                    <?php echo $categories->withQueryString()->links('pagination::bootstrap-4'); ?>


                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-company">

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        $(document).ready(function() {
            $('.select2').select2();
        })

        function updateArrangment(el) {

            $.post(`<?php echo e(route('examCategory.updateArrangment')); ?>`, {
                _token: '<?php echo e(csrf_token()); ?>',
                arrangment: el.value,
                id: el.id
            }, function(data) {

            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/aatheorie.nl/httpdocs/resources/views/admin/ExamCategory/index.blade.php ENDPATH**/ ?>