<!DOCTYPE html>
<html lang="<?php echo e(App::getLocale()); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(trans('messages.Adnan Eltaher')); ?> | <?php echo e(trans('messages.Signup')); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css"
        integrity="sha512-MV7K8+y+gLIBoVD59lQIYicR65iaqukzvf/nwasF0nqhPay5w/9lJmVM2hMDcnK1OnMGCdVK+iQrJ7lzPJQd1w=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat&family=Tajawal&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(url('front_them/assets/css/style_' . App::getLocale() . '.css')); ?>">
</head>

<body>
    <section class="container-fluid singup-container">
        <div class="row">
            <div class="col-lg-1 col-md-0 col-sm-0"></div>
            <div class="col-lg-5 col-md-7 col-sm-12 singup-form-wrapper">
                <div class="row top-nav-row">
                    <a href="<?php echo e(route('home')); ?>" class="back-link">
                        <i class="fa-sharp fa-solid fa-angle-right"></i>
                        <span><?php echo e(trans('messages.Back to home')); ?></span>
                    </a>
                </div>
                <div class="row logo mt-1 mb-3">
                    <img src="<?php echo e(url('front_them/assets/imgs/logo.png')); ?>" alt="logo image">
                </div>
                <div class="row head">
                    <h1><?php echo e(trans('messages.Create new account')); ?></h1>
                </div>
                <div class="row form-wrapper mt-1">
                    <form method="POST" action="<?php echo e(route('register')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" value="Client" name="user_type">
                        <div class="control-wrapper mb-3">
                            <label for="sinup-name" class="form-label"><?php echo e(trans('messages.Name')); ?></label>
                            <input type="text" class="form-control" id="sinup-name" name="name"
                                value="<?php echo e(old('name')); ?>" required autocomplete="name" autofocus>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="error text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="control-wrapper mb-3">
                            <label for="sinup-email" class="form-label"><?php echo e(trans('messages.Email')); ?></label>
                            <input type="email" class="form-control" id="sinup-email" placeholder="name@example.com"
                                name="email" value="<?php echo e(old('email')); ?>" required autocomplete="email">
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="error text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="control-wrapper mb-3">
                            <label for="sinup-password" class="form-label"><?php echo e(trans('messages.Password')); ?></label>
                            <div class="input-wrapper">
                                <input type="password" class="form-control" aria-describedby="signup-password-btn"
                                    id="signup-password" placeholder="******" name="password" required
                                    autocomplete="new-password">
                                <button class="btn" type="button" id="signup-password-btn">
                                    <i class="fa-regular fa-eye" id="signup-eye-icon"></i>
                                </button>
                            </div>
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="error text-danger"><?php echo e($message); ?></small>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="control-wrapper mb-3">
                            <label for="sinup-confirm-password"
                                class="form-label"><?php echo e(trans('messages.confirm password')); ?></label>
                            <div class="input-wrapper">
                                <input type="password" class="form-control"
                                    aria-describedby="signup-confirm-password-btn" id="signup-confirm-password"
                                    placeholder="******" name="password_confirmation" required
                                    autocomplete="new-password">
                                <button class="btn" type="button" id="signup-confirm-password-btn">
                                    <i class="fa-regular fa-eye" id="signup-confirm-eye-icon"></i>
                                </button>
                            </div>
                        </div>
                        <button class="btn btn-block mt-4"
                            type="submit"><?php echo e(trans('messages.Create new account')); ?></button>
                    </form>
                </div>
                <div class="row redirection-row mt-2">
                    <span><?php echo e(trans('messages.You have an account ?')); ?></span>
                    <a href="<?php echo e(route('login')); ?>"><?php echo e(trans('messages.Login')); ?></a>
                </div>
            </div>
        </div>
    </section>

    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"
        integrity="sha384-7+zCNj/IqJ95wo16oMtfsKbZ9ccEh31eOz1HGyDuCQ6wgnyJNSYdrPa03rtR1zdB" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"
        integrity="sha384-QJHtvGhmr9XOIpI6YVutG+2QOK9T+ZnN4kzFN1RtK3zEFEIsxhlmWl5/YESvpZ13" crossorigin="anonymous">
    </script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.js"></script>
    <script src="<?php echo e(url('front_them/assets/js/index.js')); ?>"></script>
</body>



</html>
<?php /**PATH D:\xampp\htdocs\eltaher\resources\views/auth/register.blade.php ENDPATH**/ ?>