<?php if($question->question_type == 'drag_drop'): ?>
    <div class="row drag-and-drop-question">
        <div class="col-lg-6 col-md-6 col-sm-12 text">
            <div class="question-head">
                <p>
                    <?php echo e($question->{'question_' . App::getLocale()}); ?>

                </p>
            </div>
            <div class="answer-wrapper">
                <?php $__currentLoopData = $question->answers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <span class="drag-num"><?php echo e($answer->{'answer_' . App::getLocale()}); ?></span>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <p class="question_explaination">
                    <?php echo e($question->{'answer_explanation_' . App::getLocale()}); ?>

                </p>
            </div>
        </div>
        <div class="col-lg-6 col-md-6 col-sm-12 img">
            <div id="answer-containers" class="answer-containers cont-ans-31" style="position: relative">
                <div class="image">
                    <img src="<?php echo e(url($question->question_image)); ?>" alt="">
                </div>
                <?php $__currentLoopData = $question->answers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(in_array($answer->{'answer_' . App::getLocale()}, $question->json_score->right_answers)): ?>
                        <div
                            style="color: #fff;font-size: 1.5em;text-align: center;width: 40px;height: 40px;background-color: rgba(27, 169, 255, 0.3);border-radius: 50%;border: 2px solid green;position: absolute;top: <?php echo e($answer->top_position); ?>%; left: <?php echo e($answer->left_position); ?>%;">
                            <?php echo e($answer->{'answer_' . App::getLocale()}); ?>

                        </div>
                    <?php else: ?>
                        <div
                            style="color: #fff;font-size: 1.5em;text-align: center;width: 40px;height: 40px;background-color: rgba(27, 169, 255, 0.3);border-radius: 50%;border: 2px solid red;position: absolute;top: <?php echo e($answer->top_position); ?>% !important; left: <?php echo e($answer->left_position); ?>% !important;">
                            <?php echo e($answer->{'answer_' . App::getLocale()}); ?>

                        </div>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
<?php elseif($question->question_type == 'mcq'): ?>
    <div class="row checkbox-question">
        <div class="col-lg-6 col-md-6 col-sm-12 text">
            <div class="question-head">
                <p class="question-text">
                    <?php echo e($question->arrangment); ?>

                    -
                    <?php echo e($question->{'question_' . App::getLocale()}); ?>

                </p>
            </div>
            <span style="color: red;display: none"
                class="answered-span"><?php echo e(trans('messages.You answered this question')); ?></span>
            <span style="color: red;display: none"
                class="skiped-span"><?php echo e(trans('messages.You skiped this question')); ?></span>
            <div class="answer-wrapper">
                <?php $__currentLoopData = $question->answers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        if (($answered == 'yes' || $answered == 'skiped') && $answer->right_answer == 1) {
                            $class = 'right-answer';
                        } elseif ($answered == 'yes' && $answer->id == $answered_id && $answer->right_answer == 0) {
                            $class = 'wrong-answer';
                        } else {
                            $class = 'no-answer';
                        }
                    ?>
                    <p class="<?php echo e($class); ?>">
                        <input type="radio" id="test<?php echo e($answer->id); ?>" name="radio-group"
                            <?php echo e($answered == 'yes' && $answer->id == $answered_id ? 'checked' : ''); ?> disabled>
                        <label for="test<?php echo e($answer->id); ?>">
                            <span class="question-answer">
                                <?php echo e($answer->{'answer_' . App::getLocale()}); ?>

                            </span>
                        </label>
                    </p>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <p class="question_explaination">
                    <?php echo e($question->{'answer_explanation_' . App::getLocale()}); ?>

                </p>
            </div>
        </div>
        <div class="col-lg-6 col-md-6 col-sm-12 img">
            <img src="<?php echo e(url($question->question_image)); ?>" alt="">
        </div>
    </div>
<?php elseif($question->question_type == 'mcq_image'): ?>
    <div class="row images-select-question">
        <div class="col-lg-12 col-md-12 col-sm-12 text">
            <div class="question-head">
                <p>
                    <?php echo e($question->{'question_' . App::getLocale()}); ?>

                </p>
            </div>
            <span style="color: red;display: none"
                class="answered-span"><?php echo e(trans('messages.You answered this question')); ?></span>
            <span style="color: red;display: none"
                class="skiped-span"><?php echo e(trans('messages.You skiped this question')); ?></span>
        </div>
        <div class="col-lg-12 col-md-12 col-sm-12 images">
            <ul>
                <?php
                    if (($answered == 'yes' || $answered == 'skiped') && $answer->right_answer == 1) {
                        $class = 'right-answer';
                    } elseif ($answered == 'yes' && $answer->id == $answered_id && $answer->right_answer == 0) {
                        $class = 'wrong-answer';
                    } else {
                        $class = 'no-answer';
                    }
                ?>
                <?php $__currentLoopData = $question->answers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="<?php echo e($class); ?>">
                        <input name="img" type="radio" id="cb<?php echo e($answer->id); ?>"
                            <?php echo e($answered == 'yes' && $answer->id == $answered_id ? 'checked' : ''); ?> disabled />
                        <label for="cb<?php echo e($answer->id); ?>"><img src="<?php echo e(url($answer->answer_image)); ?>" />

                        </label>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <p class="question_explaination">
                <?php echo e($question->{'answer_explanation_' . App::getLocale()}); ?>

            </p>
        </div>
    </div>
<?php elseif($question->question_type == 'text_input'): ?>
    <div class="row number-question">
        <div class="col-lg-6 col-md-6 col-sm-12 text">
            <div class="question-head">
                <p>
                    <?php echo e($question->{'question_' . App::getLocale()}); ?>

                </p>
            </div>
            <?php if($answered == 'skiped'): ?>
                <span style="color: red;" class="skiped-span"><?php echo e(trans('messages.You skiped this question')); ?></span>
            <?php endif; ?>
            <div class="answer-wrapper">
                <label for="answer-number" class="form-label"><?php echo e(trans('messages.Type your answer here')); ?></label>
                <?php
                    if ($answered == 'yes' && $question->answers[0]->{'answer_' . App::getLocale()} == $answer_input && $question->{'answer_explanation_' . App::getLocale()}) {
                        $class = 'right-answer-check-box';
                    } else {
                        $class = 'wrong-answer-check-box';
                    }
                ?>
                <input class="<?php echo e($class); ?>" type="number" name="answer-number" id="answer-number"
                    value="<?php echo e($answer_input); ?>" disabled>
            </div>
            <br>
            <p class="question_explaination" style="padding: 4px">
                <?php echo e($question->{'answer_explanation_' . App::getLocale()}); ?></p>
        </div>
        <div class="col-lg-6 col-md-6 col-sm-12 img">
            <img src="<?php echo e(url($question->question_image)); ?>" alt="">
        </div>
    </div>
<?php endif; ?>

<div class="row btns-row">
    <button class=" btn prev" onclick="getprevExamFinish(<?php echo e($question->id); ?>,<?php echo e($exam_id); ?>)">
        <?php if(App::getLocale() == 'ar'): ?>
            <i class="fa-solid fa-arrow-right-long"></i>
        <?php else: ?>
            <i class="fa-solid fa-arrow-left-long"></i>
        <?php endif; ?>

        <span><?php echo e(trans('messages.Prev')); ?></span>
    </button>
    <button class=" btn next" onclick="getnextExamFinish(<?php echo e($question->id); ?>,<?php echo e($exam_id); ?>)">
        <span><?php echo e(trans('messages.Next')); ?></span>
        <?php if(App::getLocale() == 'ar'): ?>
            <i class="fa-solid fa-arrow-left-long"></i>
        <?php else: ?>
            <i class="fa-solid fa-arrow-right-long"></i>
        <?php endif; ?>
    </button>
</div>
<?php /**PATH D:\xampp\htdocs\eltaher\resources\views/site/partials/test/preview_answered_question_guest.blade.php ENDPATH**/ ?>