<?php
    $header_data = App\Models\Setting::select('test_exam_id', 'home_title_' . App::getLocale() . ' as home_title', 'home_description_' . App::getLocale() . ' as home_description')->find(1);
    $packages = App\Models\Package::where('show_in_home', true)
        ->orderBy('arrangement', 'ASC')
        ->latest()->take(3)->get();
    
?>
<section class="container-fluid hero-section">
    <div class="row hero-section-row">
        <div class="col-lg-6 col-md-9 col-sm-12 data-wrapper">
            <section class="packages container">
                <?php if(App\Models\Setting::select('lang')->find(1)->lang == 'ar_nl'): ?>
                    <div class="row lang-container">
                        <a href="javascript:void(0)" data-code="nl" class="lang-change lang-btn">
                            <img src="<?php echo e(url('front_them/assets/imgs/Flag_of_the_Netherlands.png')); ?>" alt="mdo"
                                width="100" height="60">
                        </a>
                        <a href="javascript:void(0)" data-code="ar" class="lang-change lang-btn">
                            <img src="<?php echo e(url('front_them/assets/imgs/Flag_of_Saudi_Arabia.svg.png')); ?>" alt="mdo"
                                width="100" height="60">
                        </a>
                    </div>
                <?php endif; ?>
                <div class="row cards-row" id="packages-cards">
                    <?php if(session('error')): ?>
                        <div class="alert alert-danger" style="margin-bottom: 3em">
                            <?php echo e(session('error')); ?>

                        </div>
                    <?php endif; ?>
                    <?php $__empty_1 = true; $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php if($package->{'badge_' . App::getLocale()}): ?>
                            <div class="package-wrapper active animate__animated animate__zoomIn">
                                <div class="ribbon"><span><?php echo e($package->{'badge_' . App::getLocale()}); ?></span></div>
                                <h4 class="title"><?php echo e($package->{'name_' . App::getLocale()}); ?></h4>
                                <div class="price-wrapper">
                                    <p class="price">
                                        <!-- <sub class="before">100</sub> -->
                                        <span><?php echo e($package->price); ?></span>
                                        <sub>€</sub>
                                    </p>
                                </div>
                                <ul class="features">
                                    <?php echo $package->{'notes_' . App::getLocale()}; ?>

                                </ul>
                                <a href="<?php echo e(route('purchasePackage', ['package', $package->id])); ?>"
                                    class="btn"><?php echo e(trans('messages.Start now')); ?></a>
                            </div>
                        <?php else: ?>
                            <div class="package-wrapper animate__animated animate__zoomIn">
                                <h4 class="title"><?php echo e($package->{'name_' . App::getLocale()}); ?></h4>
                                <div class="price-wrapper">
                                    <p class="price">
                                        <!-- <sub class="before">100</sub> -->
                                        <span><?php echo e($package->price); ?></span>
                                        <sub>€</sub>
                                    </p>
                                </div>
                                <ul class="features">
                                    <?php echo $package->{'notes_' . App::getLocale()}; ?>

                                </ul>
                                <a href="<?php echo e(route('purchasePackage', ['package', $package->id])); ?>"
                                    class="btn"><?php echo e(trans('messages.Start now')); ?></a>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <h3><?php echo e(trans('messages.No Packages')); ?></h3>
                    <?php endif; ?>
                </div>
            </section>
            <a href="<?php echo e(route('examInfo', $header_data->test_exam_id)); ?>"
                class="btn"><?php echo e(trans('messages.Free demo test')); ?></a>
        </div>

    </div>
</section>
<?php /**PATH /var/www/vhosts/aatheorie.nl/demo.aatheorie.nl/resources/views/site/includes/home_header.blade.php ENDPATH**/ ?>