
<?php $__env->startSection('content'); ?>
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> <?php echo e(trans('messages.Subscriptions')); ?></h3>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <form action="<?php echo e(route('subscription.index')); ?>" method="GET">
                    <div class="row">
                        <div class="col-2">
                            <select name="package_id" id="exam-filter" class="select2 form-control">
                                <option value="<?php echo e(null); ?>"><?php echo e(trans('messages.All')); ?></option>
                                <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e($package_id == $package->id ? 'selected' : ''); ?> value="<?php echo e($package->id); ?>">
                                        <?php echo e($package->{'name_' . App::getLocale()}); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-2">
                            <select name="user_id" id="exam-filter" class="select2 form-control">
                                <option value="<?php echo e(null); ?>"><?php echo e(trans('messages.All')); ?></option>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e($user_id == $user->id ? 'selected' : ''); ?> value="<?php echo e($user->id); ?>">
                                        <?php echo e($user->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-2">
                            <input name="from" type="date" class="form-control" value="<?php echo e($from); ?>">
                        </div>
                        <div class="col-2">
                            <input name="to" type="date" class="form-control" value="<?php echo e($to); ?>">
                        </div>
                        <div class="col" style="position: relative">
                            <i class="fa fa-filter"
                                style="position: absolute;<?php echo e(App::getLocale() == 'ar' ? 'right' : 'left'); ?>:1em;font-size: 1.5em;line-height: 1.5em;color: #FFF"></i>
                            <input style="height: 2em;line-height: .4em;padding: 1.2em 3em" type="submit"
                                value="<?php echo e(trans('messages.Filter')); ?>" class="btn btn-primary">
                        </div>

                        <div class="col" style="text-align: end">
                            <a href="<?php echo e(route('subscription.create')); ?>"
                                class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                    class="mdi mdi-plus"><span class="path1"></span><span class="path2"></span></span></a>

                        </div>


                    </div>
                </form>
            </div>
            <div class="box-body no-padding">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr class="">
                                <th class="text-center">
                                    #
                                </th>
                                <th class="text-center"><?php echo e(trans('messages.Client')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Package')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Price')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Discount amount')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Start date')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.End date')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Created')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Options')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center">
                                        <?php echo e($key + 1 + ($subscriptions->currentPage() - 1) * $subscriptions->perPage()); ?>

                                    </td>
                                    <td class="text-center">
                                        <?php echo e($subscription->user ? $subscription->user->name : trans('messages.Guest')); ?>

                                    </td>
                                    <td class="text-center"><?php echo e($subscription->package->{'name_' . App::getLocale()}); ?></td>
                                    <td class="text-center"><?php echo e($subscription->price); ?></td>
                                    <td class="text-center"><?php echo e($subscription->offer_discount); ?></td>
                                    <td class="text-center"><?php echo e($subscription->subscription_date); ?></td>
                                    <td class="text-center"><?php echo e($subscription->expiration_date); ?></td>
                                    <td class="text-center"><?php echo e($subscription->created_at); ?></td>
                                    <td class="text-center">
                                        <form action="<?php echo e(route('subscription.destroy', $subscription->id)); ?>"
                                            method="Post" id="destroy-form-<?php echo e($subscription->id); ?>">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                        </form>
                                        <a href="<?php echo e(route('subscription.edit', $subscription->id)); ?>"
                                            class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                class="icon-Write"><span class="path1"></span><span
                                                    class="path2"></span></span></a>
                                        <a data-title="<?php echo e(trans('messages.Are you sure?')); ?>"
                                            data-no="<?php echo e(trans('messages.Cancel')); ?>"
                                            data-yes="<?php echo e(trans('messages.Yes, delete it!')); ?>"
                                            data-desc="<?php echo e(trans('messages.You will not be able to recover this!')); ?>"
                                            href="#" data-href="<?php echo e($subscription->id); ?>"
                                            class="sa-warning waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                class="icon-Trash1"><span class="path1"></span><span
                                                    class="path2"></span></span></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                    <?php echo $subscriptions->withQueryString()->links('pagination::bootstrap-4'); ?>


                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-problem">

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $('.select2').select2()
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/aatheorie.nl/demo.aatheorie.nl/resources/views/admin/Subscription/index.blade.php ENDPATH**/ ?>