
<?php $__env->startSection('content'); ?>
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> <?php echo e(trans('messages.Questions')); ?></h3>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <form action="<?php echo e(route('question.index')); ?>" method="GET">
                    <div class="row">
                        <div class="col-2">
                            <div class="app-menu">
                                <div class="search-bx mx-5">

                                    <div class="input-group">
                                        <input type="search" id="search" class="form-control" name="search"
                                            style="height: 2.8em"
                                            <?php if(isset($sort_search)): ?> value="<?php echo e($sort_search); ?>" <?php endif; ?>
                                            placeholder="<?php echo e(trans('messages.Question')); ?>" aria-label="Search"
                                            aria-describedby="button-addon2">
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <select name="exam_id" id="exam-filter" class="select2 form-control">
                                <option value="0"><?php echo e(trans('messages.All')); ?></option>
                                <?php $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e($exam_id == $exam->id ? 'selected' : ''); ?> value="<?php echo e($exam->id); ?>">
                                        <?php echo e($exam->{'name_' . App::getLocale()}); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-2" id="categories-container">

                        </div>
                        <div class="col-2">
                            <?php
                                $question_types = ['mcq' => 'MCQ', 'mcq_image' => 'MCQ image', 'text_input' => 'Text', 'drag_drop' => 'Drag & Drop'];
                            ?>
                            <select name="question_type" id="question_type-filter" class="select2 form-control">
                                <option value="0"><?php echo e(trans('messages.All')); ?></option>
                                <?php $__currentLoopData = $question_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e($question_type == $key ? 'selected' : ''); ?> value="<?php echo e($key); ?>">
                                        <?php echo e(trans('messages.' . $type)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col" style="position: relative">
                            <i class="fa fa-filter"
                                style="position: absolute;<?php echo e(App::getLocale() == 'ar' ? 'right' : 'left'); ?>:1em;font-size: 1.5em;line-height: 1.5em;color: #FFF"></i>
                            <input style="height: 2em;line-height: .4em;padding: 1.2em 3em" type="submit"
                                value="<?php echo e(trans('messages.Filter')); ?>" class="btn btn-primary">
                        </div>
                        <?php if($exam_id && $category_id): ?>
                            <div class="col" style="text-align: end">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('question_create')): ?>
                                    <a href="<?php echo e(route('question.create', ['exam_id' => $exam_id, 'category_id' => $category_id])); ?>"
                                        class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                            class="mdi mdi-plus"><span class="path1"></span><span
                                                class="path2"></span></span></a>
                                <?php endif; ?>

                            </div>
                        <?php else: ?>
                            <a href="#"
                                onclick="alert('<?php echo e(trans('messages.You can only add question on exam and category filter')); ?>')"
                                class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                    class="mdi mdi-plus"><span class="path1"></span><span class="path2"></span></span></a>
                        <?php endif; ?>

                    </div>
                </form>
            </div>
            <div class="box-body no-padding">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr class="">
                                <th class="text-center">
                                    #
                                </th>
                                <th class="text-center"><?php echo e(trans('messages.Exam')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Category')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Question')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Question type')); ?></th>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('question_update')): ?>
                                    <th class="text-center"><?php echo e(trans('messages.Arrangment')); ?></th>
                                <?php endif; ?>
                                <th class="text-center"><?php echo e(trans('messages.Image')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Created')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Options')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center">
                                        <?php echo e($key + 1 + ($questions->currentPage() - 1) * $questions->perPage()); ?>

                                    </td>
                                    <td class="text-center"><?php echo e($question->exam->{'name_' . App::getLocale()}); ?></td>
                                    <td class="text-center"><?php echo e($question->examCategory->{'name_' . App::getLocale()}); ?>

                                    </td>
                                    <td class="text-center"><?php echo e($question->question_type); ?></td>
                                    <td class="text-center"><?php echo e($question->{'question_' . App::getLocale()}); ?></td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('question_update')): ?>
                                        <td class="text-center">
                                            <div class="form-group">
                                                <input type="number" id="<?php echo e($question->id); ?>" class="form-control"
                                                    style="width: 50%;margin: auto;" onchange="updateArrangment(this)"
                                                    value="<?php echo e($question->arrangment); ?>" />
                                            </div>
                                        </td>
                                    <?php endif; ?>
                                    <td class="text-center">
                                        <?php
                                            if ($question->question_image) {
                                                $link = $question->question_image;
                                            } else {
                                                $link = '/images/noimg.png';
                                            }
                                        ?>
                                        <a class="image-popup-vertical-fit" href="<?php echo e(url($link)); ?>">
                                            <img id="question_image" src="<?php echo e(url($link)); ?>" alt="your question_image"
                                                style="width: 50px; height: 49px;" />
                                        </a>
                                    </td>
                                    <td class="text-center"><?php echo e($question->created_at); ?></td>
                                    <td class="text-center">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('question_delete')): ?>
                                            <form action="<?php echo e(route('question.destroy', $question->id)); ?>" method="Post"
                                                id="destroy-form">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                            </form>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('answer_list')): ?>
                                            <a title="<?php echo e(trans('messages.Answers')); ?>"
                                                href="<?php echo e(route('answer.index', ['question_id' => $question->id])); ?>"
                                                class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                    class="fa fa-reply-all"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('question_update')): ?>
                                            <a href="<?php echo e(route('question.edit', $question->id)); ?>"
                                                class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                    class="icon-Write"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('question_delete')): ?>
                                            <a data-title="<?php echo e(trans('messages.Are you sure?')); ?>"
                                                data-no="<?php echo e(trans('messages.Cancel')); ?>"
                                                data-yes="<?php echo e(trans('messages.Yes, delete it!')); ?>"
                                                data-desc="<?php echo e(trans('messages.You will not be able to recover this!')); ?>"
                                                href="#" data-href="<?php echo e(route('question.destroy', $question->id)); ?>"
                                                class="sa-warning waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                    class="icon-Trash1"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                    <?php echo $questions->withQueryString()->links('pagination::bootstrap-4'); ?>


                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-company">

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        function updateArrangment(el) {
            $.post(`<?php echo e(route('question.updateArrangment')); ?>`, {
                _token: '<?php echo e(csrf_token()); ?>',
                arrangment: el.value,
                id: el.id
            }, function(data) {

            });
        }

        $(document).ready(function() {
            var exam_id = $('#exam-filter').val();
            $.post(`<?php echo e(route('examCategory.getCategories')); ?>`, {
                _token: '<?php echo e(csrf_token()); ?>',
                exam_id: exam_id,
                category_id: <?php echo e($category_id ? $category_id : 0); ?>,
            }, function(data) {
                $('#categories-container').html(data)
            });

            $('#exam-filter').change(function() {
                var exam_id = $(this).val();
                $.post(`<?php echo e(route('examCategory.getCategories')); ?>`, {
                    _token: '<?php echo e(csrf_token()); ?>',
                    exam_id: exam_id,
                    category_id: <?php echo e($category_id ? $category_id : 0); ?>,
                }, function(data) {
                    $('#categories-container').html(data)
                });
            })
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\eltaher\resources\views/admin/Question/index.blade.php ENDPATH**/ ?>