<?php $__env->startSection('content'); ?>
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> <?php echo e(trans('messages.Packages')); ?></h3>
            </div>

        </div>
    </div>
    <style>
        .offer-active {
            background-color: #FFF !important;
            border-color: #1221db !important;
            color: #0ee31e !important;
        }
    </style>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <div class="row">
                    <div class="col-4">
                        <div class="app-menu">
                            <div class="search-bx mx-5">
                                <form action="<?php echo e(route('package_video.index')); ?>" method="GET">
                                    <div class="input-group">
                                        <input type="search" id="search" class="form-control" name="search"
                                               <?php if(isset($sort_search)): ?> value="<?php echo e($sort_search); ?>" <?php endif; ?>
                                               placeholder="<?php echo e(trans('messages.Title')); ?>" aria-label="Search"
                                               aria-describedby="button-addon2">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col" style="text-align: end">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('package_video_store')): ?>
                            <a href="<?php echo e(route('package_video.create')); ?>"
                               class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                    class="mdi mdi-plus"><span class="path1"></span><span
                                        class="path2"></span></span></a>
                        <?php endif; ?>

                    </div>
                </div>

            </div>
            <div class="box-body no-padding">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                        <tr class="">
                            <th class="text-center">
                                #
                            </th>
                            <th class="text-center"><?php echo e(trans('messages.Name')); ?></th>
                            <th class="text-center"><?php echo e(trans('messages.photo_phone')); ?></th>
                            <th class="text-center"><?php echo e(trans('messages.photo_desktop')); ?></th>
                            <th class="text-center"><?php echo e(trans('messages.Price')); ?></th>
                            <th class="text-center"><?php echo e(trans('messages.videos')); ?></th>
                            <th class="text-center"><?php echo e(trans('messages.Expiration duration')); ?></th>
                            <th class="text-center"><?php echo e(trans('messages.Created')); ?></th>
                            <th class="text-center"><?php echo e(trans('messages.Enabled')); ?></th>
                            <th class="text-center"><?php echo e(trans('messages.Options')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="text-center">
                                    <?php echo e($key + 1 + ($packages->currentPage() - 1) * $packages->perPage()); ?>

                                </td>
                                <td class="text-center"><?php echo e($package->{'name_' . App::getLocale()}); ?></td>
                                <td class="text-center">
                                    <?php if(!empty($package->photo_phone) && file_exists(public_path().'/'.$package->photo_phone)): ?>
                                        <?php if(in_array(pathinfo($package->photo_phone, PATHINFO_EXTENSION),["JPG","jpg","jpeg","gif","png","bmp"])): ?>
                                            <div class="col-sm-2" style="height: 50%;width: 50%;">
                                                <a class="image-popup-vertical-fit"
                                                   href="<?php echo e(url('/'.$package->photo_phone)); ?>">
                                                    <img  width="100" height="100"
                                                        src="<?php echo e(url('/'.$package->photo_phone)); ?>"
                                                        class="img-fluid" alt=""/>
                                                </a>
                                            </div>
                                        <?php else: ?>
                                            <div class="col-sm-2">
                                                <video width="200" height="200"  class="text-center" controls autoplay
                                                       >
                                                    <source src="<?php echo e(url('/'.$package->photo_phone)); ?>" type="video/mp4">
                                                </video>
                                            </div>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <?php if(!empty($package->photo_desktop) && file_exists(public_path().'/'.$package->photo_desktop)): ?>
                                        <div class="col-sm-2" style="height: 50%;width: 50%;">
                                            <?php if(in_array(pathinfo($package->photo_desktop, PATHINFO_EXTENSION),["JPG","jpg","jpeg","gif","png","bmp"])): ?>
                                                <a class="image-popup-vertical-fit"
                                                   href="<?php echo e(url('/'.$package->photo_desktop)); ?>">
                                                    <img  width="100" height="100"
                                                        src="<?php echo e(url('/'.$package->photo_desktop)); ?>"
                                                        class="img-fluid" alt=""/>
                                                </a>
                                            <?php else: ?>
                                                <video  width="200" height="200"  class="text-center" controls autoplay
                                                        src="<?php echo e(url('/'.$package->photo_desktop)); ?>"    >
                                                </video>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center"><?php echo e($package->price); ?></td>
                                <td class="text-center"><?php echo e($package->video_count); ?></td>
                                <td class="text-center"><?php echo e($package->expiration_duration_in_dayes); ?>

                                    <?php echo e(trans('messages.Day')); ?></td>
                                <td class="text-center"><?php echo e($package->created_at); ?></td>


                                <td class="text-center">
                                    <div class="form-group">
                                        <div class="checkbox">
                                            <input type="checkbox" id="Checkboxen_<?php echo e($key); ?>"
                                                   <?php if ($package->active == 1) {
                                                       echo 'checked';
                                                   } ?> onchange="updatedActive(this)"
                                                   value="<?php echo e($package->id); ?>"/>
                                            <label for="Checkboxen_<?php echo e($key); ?>"></label>
                                        </div>
                                    </div>
                                </td>

                                <td class="text-center">
                                    <a href="<?php echo e(route('package_video.show',$package->id)); ?>"
                                       title="<?php echo e(trans('messages.package-video-subscribes')); ?>"
                                       class="waves-effect waves-light btn btn-primary-light btn-circle ">
                                        <i class="ti-eye">
                                            <span class="path1"></span><span class="path2"></span>
                                        </i>
                                    </a>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('package_video_delete')): ?>
                                        <form action="<?php echo e(route('package_video.destroy', $package->id)); ?>" method="Post"
                                              id="destroy-form-<?php echo e($package->id); ?>">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                        </form>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('package_video_cerate_edit_offer')): ?>
                                        <a href="#" onclick="cerateEditOffer(<?php echo e($package->id); ?>)"
                                           title="<?php echo e(trans('messages.Make offer')); ?>"
                                           class="waves-effect waves-light btn btn-primary-light btn-circle <?php echo e($package->offer ? 'offer-active' : ''); ?> ">
                                            <i class="ti-wand">
                                                <span class="path1"></span><span class="path2"></span>
                                            </i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('package_video_cerate_edit_offer')): ?>
                                        <a href="<?php echo e(route('package_video.delOffer',$package->id)); ?>"
                                           onclick="return confirm('Are you sure?')"
                                           title="<?php echo e(trans('messages.delete offer')); ?>"
                                           class="waves-effect waves-light btn btn-primary-light btn-circle <?php echo e($package->offer ? 'offer-active' : ''); ?> ">
                                                <span class="icon-Trash1" style="color: red;"><span
                                                        class="path1"></span><span
                                                        class="path2"></span></span>
                                        </a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('package_video_edit')): ?>
                                        <a href="<?php echo e(route('package_video.edit', $package->id)); ?>"
                                           class="waves-effect waves-light btn btn-primary-light btn-circle">
                                            <span class="icon-Write"><span class="path1"></span><span
                                                    class="path2"></span></span></a>
                                    <?php endif; ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('package_video_delete')): ?>
                                        <a data-title="<?php echo e(trans('messages.Are you sure?')); ?>"
                                           data-no="<?php echo e(trans('messages.Cancel')); ?>"
                                           data-yes="<?php echo e(trans('messages.Yes, delete it!')); ?>"
                                           data-desc="<?php echo e(trans('messages.You will not be able to recover this!')); ?>"
                                           href="#" data-href="<?php echo e($package->id); ?>"
                                           class="sa-warning waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                class="icon-Trash1"><span class="path1"></span><span
                                                    class="path2"></span></span></a>
                                    <?php endif; ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                    <?php echo $packages->withQueryString()->links('pagination::bootstrap-4'); ?>


                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
    <div class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
         id="make-offer" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">

            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        function cerateEditOffer(id) {
            $.post(`<?php echo e(route('package_video.cerateEditOffer')); ?>`, {
                _token: '<?php echo e(csrf_token()); ?>',
                id: id
            }, function (data) {
                $('#make-offer .modal-dialog .modal-content').html(data);
                $('#make-offer').modal();

            });
        }

        function updatedActive(el) {
            if (el.checked) {
                var enable = 1;
            } else {
                var enable = 0;
            }
            $.post(`<?php echo e(route('package_video.changeActive')); ?>`, {
                _token: '<?php echo e(csrf_token()); ?>',
                id: el.value,
            }, function (data) {

            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\localhost\htdocs\newTaher\resources\views/admin/package_video/index.blade.php ENDPATH**/ ?>