
<?php $__env->startSection('content'); ?>
    <div class="content-header">
        <div class="d-flex align-items-center">
            <div class="mr-auto">
                <h3 class="page-title"> <?php echo e(trans('messages.Exams')); ?></h3>
            </div>

        </div>
    </div>
    <!-- Main content -->
    <section class="content">
        <div class="box">
            <div class="box-header">
                <div class="row">
                    <div class="col-4">
                        <div class="app-menu">
                            <div class="search-bx mx-5">
                                <form action="<?php echo e(route('exam.index')); ?>" method="GET">
                                    <div class="input-group">
                                        <input type="search" id="search" class="form-control" name="search"
                                            <?php if(isset($sort_search)): ?> value="<?php echo e($sort_search); ?>" <?php endif; ?>
                                            placeholder="<?php echo e(trans('messages.Name')); ?>" aria-label="Search"
                                            aria-describedby="button-addon2">
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col" style="text-align: end">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam_store')): ?>
                            <a href="<?php echo e(route('exam.create')); ?>"
                                class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                    class="mdi mdi-plus"><span class="path1"></span><span class="path2"></span></span></a>
                        <?php endif; ?>

                    </div>
                </div>

            </div>
            <div class="box-body no-padding">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr class="">
                                <th class="text-center">
                                    #
                                </th>
                                <th class="text-center"><?php echo e(trans('messages.Name')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Packages')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Questions')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Attempt No')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Duration')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Wrong to fail')); ?></th>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam_update_auto_move')): ?>
                                    <th class="text-center"><?php echo e(trans('messages.Category auto move')); ?></th>
                                <?php endif; ?>
                                <th class="text-center"><?php echo e(trans('messages.Created')); ?></th>
                                <th class="text-center"><?php echo e(trans('messages.Options')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $exams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $exam): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center">
                                        <?php echo e($key + 1 + ($exams->currentPage() - 1) * $exams->perPage()); ?>

                                    </td>
                                    <td class="text-center"><?php echo e($exam->{'name_' . App::getLocale()}); ?></td>
                                    <td class="text-center">
                                        <?php $__empty_1 = true; $__currentLoopData = $exam->packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <div class="badge badge-primary"><?php echo e($package->{'name_' . App::getLocale()}); ?>

                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center"><?php echo e($exam->questions_num); ?></td>
                                    <td class="text-center"><?php echo e($exam->attempt_num); ?></td>
                                    <td class="text-center"><?php echo e($exam->duration_in_minutes); ?>

                                        <?php echo e(trans('messages.Minutes')); ?></td>
                                    <td class="text-center"><?php echo e($exam->wrong_question_to_fail); ?>

                                        <?php echo e(trans('messages.Question')); ?></td>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam_update_auto_move')): ?>
                                        <td class="text-center">
                                            <div class="form-group">
                                                <div class="checkbox">
                                                    <input type="checkbox" id="Checkbox_<?php echo e($key); ?>"
                                                        <?php if ($exam->exam_category_auto_move == 1) {
                                                            echo 'checked';
                                                        } ?> onchange="update_auto_move(this)"
                                                        value="<?php echo e($exam->id); ?>" />
                                                    <label for="Checkbox_<?php echo e($key); ?>"></label>
                                                </div>
                                            </div>
                                        </td>
                                    <?php endif; ?>
                                    <td class="text-center"><?php echo e($exam->created_at); ?>

                                    <td class="text-center">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam_delete')): ?>
                                            <form action="<?php echo e(route('exam.destroy', $exam->id)); ?>" method="Post"
                                                id="destroy-form">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                            </form>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam_view')): ?>
                                            <a href="<?php echo e(route('exam.show', $exam->id)); ?>"
                                                class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                    class="fa fa-eye"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam_edit')): ?>
                                            <a href="<?php echo e(route('exam.edit', $exam->id)); ?>"
                                                class="waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                    class="icon-Write"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam_delete')): ?>
                                            <a data-title="<?php echo e(trans('messages.Are you sure?')); ?>"
                                                data-no="<?php echo e(trans('messages.Cancel')); ?>"
                                                data-yes="<?php echo e(trans('messages.Yes, delete it!')); ?>"
                                                data-desc="<?php echo e(trans('messages.You will not be able to recover this!')); ?>"
                                                href="#" data-href="<?php echo e(route('exam.destroy', $exam->id)); ?>"
                                                class="sa-warning waves-effect waves-light btn btn-primary-light btn-circle"><span
                                                    class="icon-Trash1"><span class="path1"></span><span
                                                        class="path2"></span></span></a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                    <?php echo $exams->withQueryString()->links('pagination::bootstrap-4'); ?>


                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
    <div class="modal modal-left fade" id="modal-left" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" id="view-company">

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script type="text/javascript">
        function update_auto_move(el) {
            if (el.checked) {
                var exam_category_auto_move = 1;
            } else {
                var exam_category_auto_move = 0;
            }
            $.post(`<?php echo e(route('exam.updateAutoMove')); ?>`, {
                _token: '<?php echo e(csrf_token()); ?>',
                id: el.value,
                exam_category_auto_move: exam_category_auto_move
            }, function(data) {

            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\eltaher\resources\views/admin/Exam/index.blade.php ENDPATH**/ ?>