<?php echo Form::open([
    'route' => 'examOpinion.siteStoreExamProblem',
    'files' => true,
    'id' => 'add-exam-problem-form',
]); ?>

<?php echo Form::hidden('exam_id', $exam_id, []); ?>

<?php echo Form::hidden('question_id', $question_id, []); ?>

<?php echo Form::hidden('user_id', $user_id, []); ?>

<div id="send-problem-alert" class="alert alert-success text-center"><?php echo e(trans('messages.Send successfully')); ?></div>
<p>
    <?php echo e(Form::radio('problem_type', 'image_upload', true, ['id' => 'image_upload'])); ?>

    <label for="image_upload"><?php echo e(trans('messages.The image is not loaded')); ?></label>
</p>
<p>
    <?php echo e(Form::radio('problem_type', 'lang_error', false, ['id' => 'lang_error'])); ?>

    <label for="lang_error"><?php echo e(trans('messages.language error')); ?></label>
</p>
<p>
    <?php echo e(Form::radio('problem_type', 'another_problem', false, ['id' => 'another_problem'])); ?>

    <label for="another_problem"><?php echo e(trans('messages.another thing')); ?></label>
</p>
<div class="text-area-wrapper">
    <label for="desc" class="form-label"><?php echo e(trans('messages.Description')); ?></label>
    <?php echo Form::textarea('problem_descreption', null, [
        'id' => 'problem_descreption',
        'class' => 'form-control',
        'placeholder' => trans('messages.Description'),
    ]); ?>

</div>

<div class="btn-row mt-5">
    <button class="btn" type="submit">
        <span><?php echo e(trans('messages.Send')); ?></span>
    </button>
</div>
<?php echo Form::Close(); ?>


<script type="text/javascript">
    $('#send-problem-alert').hide();
    $('#add-exam-problem-form').on('submit', function(e) {
        e.preventDefault();
        var formData = new FormData(this);
        $.ajax({
            url: "<?php echo e(route('examOpinion.siteStoreExamProblem')); ?>",
            type: "POST",
            data: formData,
            success: function(msg) {
                $('#send-problem-alert').show();
                setTimeout(() => {
                    $('#send-problem-alert').hide();
                    // $('#report-modal').modal('hide');
                }, 2000);
                console.log(msg)
            },
            error: function(xhr, status, error) {
                console.log(error)
            },
            cache: false,
            contentType: false,
            processData: false
        });
    });
</script>
<?php /**PATH /var/www/vhosts/aatheorie.nl/demo.aatheorie.nl/resources/views/site/partials/test/report_modal.blade.php ENDPATH**/ ?>