<?php

namespace Illuminate\Foundation\Auth;

use App\Models\Offer;
use App\Models\Package;
use App\Models\Setting;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Mollie\Laravel\Facades\Mollie;


trait RegistersUsers
{
    use RedirectsUsers;

    /**
     * Show the application registration form.
     *
     * @return \Illuminate\View\View
     */
    public function showRegistrationForm()
    {
        $youtube = Setting::first()->login_youtube;
        $packeds = Package::where('active',1)->get();
        $methods= Mollie::api()->methods->allActive();
        if ($youtube != null) {
            $regExp = '/^.*((youtu.be\/)|(v\/)|(\/u\/\w\/)|(embed\/)|(watch\?))\??v?=?([^#&?]*).*/';
            $match = preg_match($regExp, $youtube, $matches);
            $video_id = ($match && strlen($matches[7]) == 11) ? $matches[7] : 'not_valid';
        }
        $youtubeId = isset($video_id)?$video_id:null;
        return view('auth.register')
            ->with('packeds',$packeds)
            ->with('methods',$methods)
            ->with('youtubeId',$youtubeId);
    }

    /**
     * Handle a registration request for the application.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\JsonResponse
     */
    public function register(Request $request)
    {

        $this->validator($request->all())->validate();

        event(new Registered($user = $this->create($request->all())));

        $this->guard()->login($user);

     return $this->registered($request, $user);


        return $request->wantsJson()
            ? new JsonResponse([], 201)
            : redirect($this->redirectPath());
    }

    /**
     * Get the guard to be used during registration.
     *
     * @return \Illuminate\Contracts\Auth\StatefulGuard
     */
    protected function guard()
    {
        return Auth::guard();
    }

    /**
     * The user has been registered.
     *
     * @param \Illuminate\Http\Request $request
     * @param mixed $user
     * @return mixed
     */
    protected function registered(Request $request, $user)
    {
        $data = $request->all();
        $package = Package::find($data['package']);
        if ($package->offer) {
            $type = 'offer';
            $id = $package->offer->id;
        } else {
            $type = 'package';
            $id = $package->id;
        }
        if ($type == 'package') {
            if ($package) {
                $payment = Mollie::api()->payments->create([
                    "amount" => [
                        "currency" => "EUR",
                        "value" => number_format($package->price, 2, '.', '')  // You must send the correct number of decimals, thus we enforce the use of strings
                    ],
                    "description" => "Purchase Package #" . $package->{'name_' . App::getLocale()},
                    "redirectUrl" => route('purchaseDone', $user->id),
                    "webhookUrl" => route('webhooks.mollie',"package"),
                    "metadata" => [
                        "order_id" => $id . $user->id,
                        "price" => $package->price,
                        "expiration_duration_in_dayes" => $package->expiration_duration_in_dayes,
                        "package_id" => $package->id,
                        "offer_discount" => 0,
                        "offer_id" => null,
                        "user_id" => $user->id,
                        "user_name" => $user->name,
                        "lang" => App::getLocale(),
                    ],
                    "method" => $data['payment'],
                ]);
                return redirect($payment->getCheckoutUrl(), 303);
            }
        } elseif ($type == 'offer') {
            $offer = Offer::find($id);
            if ($offer) {
                if (($offer->package->price - $offer->discount_amount) < 0) {
                    return redirect()->back()->with("error1", trans('messages.This offer is expired you can subscrib available offers'));
                }
                $payment = Mollie::api()->payments->create([
                    "amount" => [
                        "currency" => "EUR",
                        "value" => number_format(($offer->package->price - $offer->discount_amount), 2, '.', '')  // You must send the correct number of decimals, thus we enforce the use of strings
                    ],
                    "description" => "Purchase Package #" . $offer->package->{'name_' . App::getLocale()},
                    "redirectUrl" => route('purchaseDone', $user->id),
                    "webhookUrl" => route('webhooks.mollie',"package"),
                    "metadata" => [
                        "order_id" => $id . $user->id,
                        "price" => $offer->package->price,
                        "expiration_duration_in_dayes" => $offer->package->expiration_duration_in_dayes,
                        "package_id" => $offer->package->id,
                        "offer_discount" => $offer->discount_amount,
                        "offer_id" => $offer->id,
                        "user_id" => $user->id,
                        "user_name" => $user->name,
                        "lang" => App::getLocale(),
                    ],
                    "method" => $data['payment'],
                ]);
                return redirect($payment->getCheckoutUrl(), 303);
            }
        } else {
            abort(404);
        }
    }
}
