<?php

namespace App\Http\Controllers\Api\General;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\PageResource;
use App\Sys\Services\General\StaticPageService;

class ContentController extends Controller
{
    use ApiResponse;
    protected $staticPageService;

    public function __construct(StaticPageService $staticPageService)
    {
        $this->staticPageService = $staticPageService;
    }

    public function getStaticPageContent($type)
    {
        $content = $this->staticPageService->staticContentByPageType($type);

        if (! $content) {
            return $this->apiResponse(400, 'fail', null, null);
        }

        $response = new PageResource($content);

        return $this->apiResponse(200, 'All data', null, $response);
    }
}
