<?php

namespace App\Http\Controllers\Api\Packages;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\PackagesCollection;
use App\Sys\Services\Packages\PackageService;

class PackageController extends Controller
{
    use ApiResponse;

    protected $packageService;

    public function __construct(PackageService $packageService)
    {
        $this->packageService = $packageService;
    }

    public function packages($limit)
    {

        $response = $this->packageService->getActivePackages($limit);

        $packages = new PackagesCollection($response);

        return $this->apiResponse(200, 'All Data', null, $packages);
    }
}
