<?php

namespace App\Http\Controllers\Api\Packages;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\VideoResource;
use Illuminate\Support\Facades\Auth;
use App\Http\Resources\PackageVideoCollection;
use App\Http\Resources\PackageVideoResource;
use App\Sys\Services\Packages\PackageVideoService;

class PackageVideoController extends Controller
{
    use ApiResponse;

    protected $packageVideoService;

    public function __construct(PackageVideoService $packageVideoService)
    {
        $this->packageVideoService = $packageVideoService;
    }

    public function packages($limit)
    {
        $response = $this->packageVideoService->getActivePackages($limit);

        if (! $response) {
            return $this->apiResponse(400, 'fail', null, null);
        }

        $packages = new PackageVideoCollection($response);

        return $this->apiResponse(200, 'All Data', null, $packages);
    }

    public function subscribedPackageVideos()
    {
        $userId = Auth::guard('api')->user()->id;

        $response = $this->packageVideoService->getVideosWithWatchProgress($userId);

        if (! $response) {
            return $this->apiResponse(400, 'fail', $this->packageVideoService->errors(), null);
        }

        $videos = new PackageVideoResource($response);

        return $this->apiResponse(200, 'All Data', null, $videos);
    }

    public function getSelectedVideo($videoId)
    {
        $userId = Auth::guard('api')->user()->id;

        $video = $this->packageVideoService->getSelectedVideoById($userId, $videoId);

        if (! $video) {
            return $this->apiResponse(400, 'fail', $this->packageVideoService->errors(), null);
        }
        $response = [
            'url' => 'https://player.vimeo.com/video/' . $video->url,
            'current_watch_count' => $video->videoShows->first()->count_watch,
            'photo' => $video->photo,
        ];
        return $this->apiResponse(200, 'All Data', null, $response);
    }
}
