<?php

namespace App\Http\Controllers\Api\Questions;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\FavoriteQuestionCollection;
use App\Http\Resources\QuestionResource;
use App\Sys\Services\Questions\FavoriteQuestionService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class FavoriteQuestionController extends Controller
{
    use ApiResponse;

    protected $favoriteQuestionService;

    public function __construct(FavoriteQuestionService $favoriteQuestionService)
    {
        $this->favoriteQuestionService = $favoriteQuestionService;
    }

    public function addFavorite(Request $request)
    {
        $userId = Auth::guard('api')->user()->id;

        if (! $this->favoriteQuestionService->addFavoriteQuestion($userId, $request->all())) {
            $error = $this->favoriteQuestionService->errors();

            return $this->apiResponse(400, 'fail', $error, null);
        }

        return $this->apiResponse(200, 'Question added', null, null);
    }

    public function removeFavorite(Request $request)
    {
        $userId = Auth::guard('api')->user()->id;

        if (! $this->favoriteQuestionService->removeFavoriteQuestion($request->all(), $userId)) {
            $error = $this->favoriteQuestionService->errors();

            return $this->apiResponse(400, 'fail', $error, null);
        }

        return $this->apiResponse(200, 'Question removed', null, null);
    }

    public function getFavoriteQuestions($limit)
    {
        $userId = Auth::guard('api')->user()->id;

        $favoriteQuestions = $this->favoriteQuestionService->getFavoriteQuestions($limit, $userId);

        $response = new FavoriteQuestionCollection($favoriteQuestions);

        return $this->apiResponse(200, 'All data', null, $response);
    }

    public function getSelectedFavoriteQuestion($favoriteId)
    {
        $userId = Auth::guard('api')->user()->id;

        $favoriteQuestion = $this->favoriteQuestionService->getSelectedFavoriteQuestion($userId, $favoriteId);

        $error = $this->favoriteQuestionService->errors();

        if (! $favoriteQuestion) {
            return $this->apiResponse(400, 'fail', $error, null);
        }

        $results = new QuestionResource($favoriteQuestion->question);

        return $this->apiResponse(200, 'All data', null, $results);
    }
}
