<?php

namespace App\Http\Controllers\Api\Questions;

use App\ApiResponse;
use App\Http\Controllers\Controller;
use App\Sys\Services\Questions\ReportQuestionService;
use Illuminate\Http\Request;

class ReportQuestionController extends Controller
{
    use ApiResponse;

    protected $reportQuestionService;

    public function __construct(ReportQuestionService $reportQuestionService)
    {
        $this->reportQuestionService = $reportQuestionService;
    }

    public function reportQuestion(Request $request)
    {
        if ($this->reportQuestionService->storeReport($request->all())) {
            return $this->apiResponse(200, 'Success', null, null);
        }

        $error = $this->reportQuestionService->errors();

        return $this->apiResponse(400, 'fail', $error, null);
    }
}
