<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Mail\RegisterEmail;
use App\Models\Offer;
use App\Models\Package;
use App\Models\Subscription;
use App\Providers\RouteServiceProvider;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Mollie\Laravel\Facades\Mollie;
use Illuminate\Support\Facades\Auth;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(Request $request)
    {
        $this->middleware('guest');
        if ($request->has('prev')) {
            if ($request->prev == 'theory-package') {
                $this->redirectTo = '/theory-package/view/' . $request->prevId . '?openmodel=true';
            }
        }
    }


    /**
     * Get a validator for an incoming registration request.
     *
     * @param array $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required','string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8'],
            'package' => ['required'],
        ]);

    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param array $data
     * @return \App\Models\User
     */
    protected function create(array $data)
    {

        $user = User::create([
            'name' => $data['name'],
            'phone' => (isset($data['phone'])) ? $data['phone'] : null,
            'email' => $data['email'],
            'user_type' => $data['user_type'],
            'email_verified_at' => date('Y-m-d H:i:s'),
            'password' => Hash::make($data['password']),
            'package_id' => $data['package']
        ]);
        // send email notification
        //  Mail::to($user->email)->send(new RegisterEmail($user->name));


            //Mail::to('Adnaanaltaher@aatheorie.nl')->send(new RegisterEmail($user->name));


             return $user;
        }
    }

