<?php

namespace App\Http\Controllers\Site;

use App\Http\Controllers\Controller;
use App\Mail\SubscriptionEmail;
use App\Models\Offer;
use App\Models\PackageVideo;
use App\Models\PackageVideoOffers;
use App\Models\PackageVideoSubscriptions;
use App\Models\PackageVideoUserWatch;
use App\Models\PackageVideoVideo;
use App\Models\Setting;
use App\Models\User;
use App\Models\Videos;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Mollie\Laravel\Facades\Mollie;
use Validator;
use RealRashid\SweetAlert\Facades\Alert as Alert;

class PackagesVideosControllers extends Controller
{

    public function start_package($id = 0)
    {
        if (Auth()->check()) {
            $if_subscribed = PackageVideoSubscriptions::where(['user_id' => auth()->user()->id])->whereDate('expiration_date', '>', now())->get();
            if (!empty($if_subscribed)) {
                    return redirect()->route('PackageVideovideos');
            }
            $packeds = PackageVideo::where('active', 1)->get();
            $methods = Mollie::api()->methods->allActive();
            return view('site.getpaymentVideo')
                ->with('packeds', $packeds)
                ->with('id', $id)
                ->with('methods', $methods);
        } else {
            return redirect()->to('register');
        }
    }

    public function videos()
    {
        $videosIds = PackageVideoSubscriptions::where([
            ['user_id', Auth::user()->id],
            ['expiration_date', '>=', Carbon::now()]
        ])->pluck('package_id')->toArray();
        $packages = [];
        if (!empty($videosIds)) {
            $packages = PackageVideo::whereIn('id', $videosIds)->get();
        }
        return view('site.videos')->with('packages', $packages);
    }

    public function ShowVideos($id)
    {
        $subscroption = PackageVideoSubscriptions::where([
            ['user_id', Auth::user()->id],
            ['expiration_date', '>=', Carbon::now()],
            ['package_id', $id]
        ])->first();
        if (!empty($subscroption)) {
            if ($subscroption->count_play <= $subscroption->total_view_play) {
                $packeds = PackageVideo::where('active', 1)->get();
                $methods = Mollie::api()->methods->allActive();
                return view('site.getpaymentVideo')
                    ->with('packeds', $packeds)
                    ->with('id', $id)
                    ->with('methods', $methods);
            }
            $package = PackageVideo::with('video')->find($id);
            $showVideos = PackageVideoUserWatch::where([
                ['user_id', Auth()->user()->id],
                ['subscription_id', $subscroption->id],
                ['package_id', $package->id],
            ])->get();
            $myVideos = [];
            return view('site.listVideos')
                ->with('subscroption', $subscroption)
                ->with('showVideos', $showVideos)
                ->with('myVideos', $myVideos)
                ->with('package', $package);
        }
        Alert::success(__('messages.success'), __('messages.Need Subscribtion for Packaged'));
        return redirect()->route('start_package_PackageVideo');
    }

    public function getVideo($id, $package)
    {

        $myVideos = Videos::find($id);
        $packages = PackageVideo::with('video')->find($package);
        if (!empty($myVideos) && !empty($packages)) {
            $subscroption = PackageVideoSubscriptions::where([
                ['user_id', Auth::user()->id],
                ['expiration_date', '>=', Carbon::now()],
                ['package_id', $package]
            ])->first();
            if ($subscroption->count_play >= $subscroption->total_view_play) {

                $subscroption->total_view_play = $subscroption->total_view_play + 1;
                $subscroption->save();
                $SubVideos = PackageVideoUserWatch::where([
                    ['user_id', Auth()->user()->id],
                    ['subscription_id', $subscroption->id],
                    ['package_id', $packages->id],
                    ['video_id', $id]
                ])->first();
                if (!empty($SubVideos)) {
                    if ($SubVideos->count_watch < $subscroption->one_count_play) {

                        $SubVideos->count_watch = $SubVideos->count_watch + 1;
                        $SubVideos->save();
                    } else {
                        $myVideos = [];
                    }
                } else {
                    $addSubView = new PackageVideoUserWatch();
                    $addSubView->user_id = Auth()->user()->id;
                    $addSubView->package_id = $package;
                    $addSubView->video_id = $id;
                    $addSubView->count_watch = 1;
                    $addSubView->subscription_id = $subscroption->id;
                    $addSubView->save();
                    $SubVideos= $addSubView;
                }

                $showVideos = PackageVideoUserWatch::where([
                    ['user_id', Auth()->user()->id],
                    ['subscription_id', $subscroption->id],
                    ['package_id', $packages->id],
                ])->get();

                if($myVideos == null)
                    Alert::error(__('messages.error'), __('messages.end video show alert'));


                return view('site.listVideos')
                    ->with('subscroption', $subscroption)
                    ->with('showVideos', $showVideos)
                    ->with('myVideos', $myVideos)
                    ->with('SubVideos', $SubVideos)
                    ->with('package', $packages);
            }
        }

        Alert::success(__('messages.success'), __('messages.Need Subscribtion for Packaged'));
        return redirect()->route('start_package_PackageVideo');
    }

    public function purchasePackageVideoPushers(Request $request)
    {
        $data = $request->all();
        $rules = [
            'package' => 'required'
        ];
        $user_email = auth()->user()->email;
        $user_phone = auth()->user()->phone;
        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            return redirect()->back()->with($validator->errors());
        }
        $package = PackageVideo::find($data['package']);
        if (!empty($package)) {
            if ($package->offer) {
                $type = 'offer';
                $id = $package->offer->id;
            } else {
                $type = 'package';
                $id = $package->id;
            }
            if ($type == 'package') {
                $payment = Mollie::api()->payments->create([
                    "amount" => [
                        "currency" => "EUR",
                        "value" => number_format($package->price, 2, '.', '')
                    ],
                    "description" => "Package video #" . $package->{'name_' . App::getLocale()} . "- email : $user_email" . ' ' . " - phone : $user_phone ",
                    "redirectUrl" => route('purchaseDonePackageVideoPushers', auth()->user()->id),
                    "webhookUrl" => route('webhooks.mollie',"video"),
                    "metadata" => [
                        "order_id" => $id . auth()->user()->id,
                        "price" => $package->price,
                        "expiration_duration_in_dayes" => $package->expiration_duration_in_dayes,
                        "package_id" => $package->id,
                        "offer_discount" => 0,
                        "offer_id" => null,
                        // "count_play" => $package->count_play,
                        // "one_video_play" => $package->show_one_video,
                        "user_id" => auth()->user()->id,
                        "user_name" => auth()->user()->name,
                        "name_package" => "video",
                        "lang" => App::getLocale(),
                    ],
                    "method" => $data['payment'],
                ]);

                return redirect($payment->getCheckoutUrl(), 303);
            } elseif ($type == 'offer') {
                $offer = PackageVideoOffers::find($id);
                if (!empty($offer)) {
                    if (Carbon::now()->gt(date('Y-m-d H:i', strtotime($offer->end_date)))) {
                        return redirect()->back()->with("error1", trans('messages.This offer is expired you can subscrib available offers'));
                    }
                    if (($offer->package->price - $offer->discount_amount) < 0) {
                        return redirect()->back()->with("error1", trans('messages.This offer is expired you can subscrib available offers'));
                    }
                    $payment = Mollie::api()->payments->create([
                        "amount" => [
                            "currency" => "EUR",
                            "value" => number_format(($offer->package->price - $offer->discount_amount), 2, '.', '')  // You must send the correct number of decimals, thus we enforce the use of strings
                        ],
                        "description" => "Package video #" . $offer->package->{'name_' . App::getLocale()} . "- email : $user_email" . ' ' . " - phone : $user_phone ",
                        "redirectUrl" => route('purchaseDonePackageVideoPushers', auth()->user()->id),
                        "webhookUrl" => route('webhooks.mollie',"video"),
                        "metadata" => [
                            "order_id" => $id . auth()->user()->id,
                            "price" => $offer->package->price,
                            "expiration_duration_in_dayes" => $offer->package->expiration_duration_in_dayes,
                            "package_id" => $offer->package->id,
                            "offer_discount" => $offer->discount_amount,
                            "offer_id" => $offer->id,
                            "count_play" => $package->count_play,
                            "one_video_play" => $package->show_one_video,
                            "user_id" => auth()->user()->id,
                            "user_name" => auth()->user()->name,
                            "name_package" => "video",
                            "lang" => App::getLocale(),
                        ],
                        "method" => $data['payment'],
                    ]);
                    return redirect($payment->getCheckoutUrl(), 303);

                }

            }
        }
        abort(404);
    }

    public function purchaseDonePackageVideoPushers($id)
    {
        $updateUserFlash = User::find($id);
        $flash_message = $updateUserFlash->flash_message;
        $updateUserFlash->flash_message = null;
        $updateUserFlash->save();
        return redirect()->route('home')->with("success", $flash_message);
    }

    public function handleWebhookpackageVideos(Request $request)
    {
        $setting = Setting::find(1);
        $data['first_phone'] = $setting->main_phone;
        $data['secound_phone'] = $setting->secoundry_phone;
        $data['email'] = $setting->email;
        $data['address_ar'] = $setting->address_ar;
        $data['address_nl'] = $setting->address_nl;
        $paymentId = $request->input('id');
        $payment = Mollie::api()->payments->get($paymentId);
        $oldsubscribtion = PackageVideoSubscriptions::where(['user_id' => $payment->metadata->user_id, 'package_id' => $payment->metadata->package_id])->first();
        $updateUserFlash = User::find($payment->metadata->user_id);
        if ($payment->isPaid()) {
            if ($oldsubscribtion) {
                $oldsubscribtion->offer_discount = $payment->metadata->offer_discount;
                $oldsubscribtion->price = $payment->metadata->price;
                $oldsubscribtion->count_play = $payment->metadata->count_play;
                $oldsubscribtion->one_count_play = $payment->metadata->one_video_play;
                $oldsubscribtion->subscription_date = date('Y-m-d H:i');
                $oldsubscribtion->expiration_date = date('Y-m-d H:i', strtotime('+' . $payment->metadata->expiration_duration_in_dayes . ' days'));
                $oldsubscribtion->pay_type = 'visa';
                $oldsubscribtion->renewed_times += 1;
                $oldsubscribtion->total_view_play = 0;
                $oldsubscribtion->save();
                $data['user'] = $updateUserFlash;
                $data['packageName'] = $oldsubscribtion->package->{'name_' . $payment->metadata->lang};
                $data['subscribtion'] = $oldsubscribtion;
                $data['lang'] = $payment->metadata->lang;
                Mail::to($updateUserFlash->email)->send(new SubscriptionEmail($data));
                //Mail::to('Adnaanaltaher@aatheorie.nl')->send(new SubscriptionEmail($data));
            } else {
                $subscription = new PackageVideoSubscriptions();
                $subscription->package_id = $payment->metadata->package_id;
                $subscription->offer_id = $payment->metadata->offer_id;
                $subscription->offer_discount = $payment->metadata->offer_discount;
                $subscription->price = $payment->metadata->price;
                $subscription->user_id = $payment->metadata->user_id;
                $subscription->subscription_date = date('Y-m-d H:i');
                $subscription->expiration_date = date('Y-m-d H:i', strtotime('+' . $payment->metadata->expiration_duration_in_dayes . ' days'));
                $subscription->count_play = $payment->metadata->count_play;
                $subscription->one_count_play = $payment->metadata->one_video_play;
                $subscription->pay_type = 'visa';
                $subscription->save();
                $data['user'] = $updateUserFlash;
                $data['packageName'] = $subscription->package->{'name_' . $payment->metadata->lang};
                $data['subscribtion'] = $subscription;
                $data['lang'] = $payment->metadata->lang;
                Mail::to($updateUserFlash->email)->send(new SubscriptionEmail($data));
                // Mail::to('Adnaanaltaher@aatheorie.nl')->send(new SubscriptionEmail($data));
            }
            $updateUserFlash->flash_message = trans('messages.Subscribed successfully');
            $updateUserFlash->package_id = null;
            $updateUserFlash->save();
        } elseif ($payment->isCanceled()) {
            $updateUserFlash->flash_message = trans('messages.Payment canceled');
            $updateUserFlash->save();
        } elseif ($payment->isExpired()) {
            $updateUserFlash->flash_message = trans('messages.Payment expired');
            $updateUserFlash->save();
        } elseif ($payment->isFailed()) {
            $updateUserFlash->flash_message = trans('messages.Payment Failed');
            $updateUserFlash->save();
        } else {
            $updateUserFlash->flash_message = trans('messages.open');
            $updateUserFlash->save();
        }
    }
}
