<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AnswerResource extends JsonResource
{

    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'answer' => $this->answer,
            'main_answer' => $this->main_answer,
            'right_answer' => $this->right_answer,
            'top_position' => $this->top_position,
            'left_position' => $this->left_position,
            'arrangment' => $this->arrangment,
            'photo' => $this->photo,
            'photo_extension' => $this->checkExtions($this->photo),
        ];
    }

    public function checkExtions($pro)
    {
        if ($pro != null) {
            $extension = pathinfo($pro, PATHINFO_EXTENSION);
            $imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
            if (in_array(pathinfo($pro, PATHINFO_EXTENSION), ["jpg", "jpeg", "gif", "png", "bmp", "webp", "PNG", "GIF", "JPG"]))
                return 'photo';

            return 'video';
        }

        return null;
    }
}
