<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class VideoResource extends JsonResource
{

    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'url' => null,
            'name' => $this->name,
            'desc' => $this->desc,
            'photo' => $this->photo,
            'photo_extension' => $this->checkExtions($this->photo),
            'is_active' => $this->is_active,
            'video_shows' => $this->whenLoaded('videoShows', function () {
                if ($this->videoShows && $this->videoShows->isNotEmpty()) {
                    return $this->videoShows->first()->count_watch;
                }
                return 0;
            }, 0),
        ];
    }

    public function checkExtions($pro)
    {
        if ($pro != null) {
            $extension = pathinfo($pro, PATHINFO_EXTENSION);
            $imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
            if (in_array(pathinfo($pro, PATHINFO_EXTENSION), ["jpg", "jpeg", "gif", "png", "bmp", "webp", "PNG", "GIF", "JPG"]))
                return 'photo';

            return 'video';
        }

        return null;
    }
}
