<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\App;

class Answer extends Model
{
    use HasFactory;

    protected $fillable = [
        'answer_ar',
        'answer_en',
        'answer_nl',
        'main_answer',
        'question_id',
        'right_answer',
        'top_position',
        'left_position',
        'arrangment',
        'answer_image',
    ];

    protected $appends = ['answer', 'photo'];

    public function getAnswerAttribute()
    {
        return $this->{'answer_' . App::getLocale()} == null ? $this->answer_ar : $this->{'answer_' . App::getLocale()};
    }
    public function getPhotoAttribute()
    {
        return ($this->answer_image != null && file_exists(public_path() . '/' . $this->answer_image)) ? url('/' . $this->answer_image) : null;
    }

    public function question()
    {
        return $this->belongsTo(Question::class, 'question_id');
    }
}
