<?php

namespace App\Models;

use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class BlogCategory extends Model
{
    use HasFactory;

    protected $fillable = [
        'name_ar',
        'name_en',
        'name_nl',
        'slug_ar',
        'slug_en',
        'slug_nl',
        'arrangement',
        'image'
    ];
    public function getNameAttribute()
    {
        return $this->{'name_' . App::getLocale()} == null ? $this->name_ar : $this->{'name_' . App::getLocale()};
    }
    public function getSlugAttribute()
    {
        return $this->{'slug_' . App::getLocale()} == null ? $this->slug_ar : $this->{'slug_' . App::getLocale()};
    }

    public function getPhotoAttribute()
    {
        return $this->image != null && file_exists(public_path() . '/' . $this->image) ? url('/' . $this->image) : null;
    }
    public function blogs()
    {
        return $this->hasMany(Blog::class, 'blog_category_id');
    }
}
