<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\App;

class PackageVideo extends Model
{
    use softDeletes;
    protected $table = 'package_video';

    protected $appends = [
        'name',
        'notes',
        'badge',
        'phonePhoto',
        'desktopPhoto',
        'coverPhone',
        'coverDesktop',
    ];
    public function getNameAttribute()
    {
        return $this->{'name_' . App::getLocale()} == null ? $this->name_ar : $this->{'name_' . App::getLocale()};
    }
    public function getNotesAttribute()
    {
        return $this->{'notes_' . App::getLocale()} == null ? $this->name_ar : $this->{'notes_' . App::getLocale()};
    }
    public function getBadgeAttribute()
    {
        return $this->{'badge_' . App::getLocale()} == null ? $this->name_ar : $this->{'badge_' . App::getLocale()};
    }
    public function getCoverDesktopAttribute()
    {
        return $this->{'cove_desktop_' . App::getLocale()} != null && file_exists(public_path() . '/' . $this->{'cove_desktop_' . App::getLocale()}) ? url('/' . $this->{'cove_desktop_' . App::getLocale()}) : null;
    }
    public function getPhonePhotoAttribute()
    {
        return $this->photo_phone != null && file_exists(public_path() . '/' . $this->photo_phone) ? url('/' . $this->photo_phone) : null;
    }
    public function getDesktopPhotoAttribute()
    {
        return $this->photo_desktop != null && file_exists(public_path() . '/' . $this->photo_desktop) ? url('/' . $this->photo_phone) : null;
    }
    public function getCoverPhoneAttribute()
    {
        return $this->{'cove_phone_' . App::getLocale()} != null && file_exists(public_path() . '/' . $this->{'cove_phone_' . App::getLocale()}) ? url('/' . $this->{'cove_phone_' . App::getLocale()}) : null;
    }


    public function video()
    {
        return $this->belongsToMany(Videos::class, 'package_video_video', 'package_id', 'video_id');
    }

    public function offer()
    {
        return $this->hasOne(PackageVideoOffers::class, 'package_id')->where('end_date', '>', Carbon::now());
    }
}
