<?php

namespace App\Models;

use Illuminate\Support\Facades\App;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Setting extends Model
{
    use HasFactory;
    protected $fillable = [
        'home_meta_tags_ar',
        'home_meta_tags_en',
        'home_meta_tags_nl',
        'home_meta_title_ar',
        'home_meta_title_en',
        'home_meta_title_nl',
        'sit_title_ar',
        'sit_title_en',
        'sit_title_nl',
        'home_meta_description_ar',
        'home_meta_description_en',
        'home_meta_description_nl',
        'home_meta_image',
        'facebook',
        'tweeter',
        'whatsapp',
        'youyube',
        'home_title_ar',
        'home_title_en',
        'home_title_nl',
        'home_description_ar',
        'home_description_en',
        'home_description_nl',
        'test_exam_id',
        'why_eltaher_desc_ar',
        'why_eltaher_desc_en',
        'why_eltaher_desc_nl',
        'why_eltaher_first_title_ar',
        'why_eltaher_first_title_en',
        'why_eltaher_first_title_nl',
        'why_eltaher_first_desc_ar',
        'why_eltaher_first_desc_en',
        'why_eltaher_first_desc_nl',
        'why_eltaher_secound_title_ar',
        'why_eltaher_secound_title_en',
        'why_eltaher_secound_title_nl',
        'why_eltaher_secound_desc_ar',
        'why_eltaher_secound_desc_en',
        'why_eltaher_secound_desc_nl',
        'lang',
        'default_lang',
        'lang_ar',
        'lang_en',
        'lang_nl',
        'reserve_exam_desc_ar',
        'reserve_exam_desc_en',
        'reserve_exam_desc_nl',
        'footer_desc_ar',
        'footer_desc_en',
        'footer_desc_nl',
        'main_phone',
        'secoundry_phone',
        'email',
        'address_ar',
        'address_en',
        'address_nl',
        'lat',
        'lon',
        'exam_header_description_ar',
        'exam_header_description_en',
        'exam_header_description_nl',
        'login_youtube'
    ];
    protected $appends = [
        'home_meta_tags',
        'home_meta_title',
        'sit_title',
        'home_meta_description',
        'home_title',
        'home_description',
        'why_eltaher_desc',
        'why_eltaher_first_title',
        'why_eltaher_first_desc',
        'why_eltaher_second_title',
        'why_eltaher_second_desc',
        'reserve_exam_desc',
        'footer_desc',
        'address',
        'exam_header_description',
    ];

    public function getHomeMetaTagsAttribute()
    {
        return $this->{'home_meta_tags_' . App::getLocale()} == null ? $this->home_meta_tags_ar : $this->{'home_meta_tags_' . App::getLocale()};
    }

    public function getHomeMetaTitleAttribute()
    {
        return $this->{'home_meta_title_' . App::getLocale()} == null ? $this->home_meta_title_ar : $this->{'home_meta_title_' . App::getLocale()};
    }

    public function getSitTitleAttribute()
    {
        return $this->{'sit_title_' . App::getLocale()} == null ? $this->sit_title_ar : $this->{'sit_title_' . App::getLocale()};
    }

    public function getHomeMetaDescriptionAttribute()
    {
        return $this->{'home_meta_description_' . App::getLocale()} == null ? $this->home_meta_description_ar : $this->{'home_meta_description_' . App::getLocale()};
    }

    public function getHomeTitleAttribute()
    {
        return $this->{'home_title_' . App::getLocale()} == null ? $this->home_title_ar : $this->{'home_title_' . App::getLocale()};
    }

    public function getHomeDescriptionAttribute()
    {
        return $this->{'home_description_' . App::getLocale()} == null ? $this->home_description_ar : $this->{'home_description_' . App::getLocale()};
    }

    public function getWhyEltaherDescAttribute()
    {
        return $this->{'why_eltaher_desc_' . App::getLocale()} == null ? $this->why_eltaher_desc_ar : $this->{'why_eltaher_desc_' . App::getLocale()};
    }

    public function getWhyEltaherFirstTitleAttribute()
    {
        return $this->{'why_eltaher_first_title_' . App::getLocale()} == null ? $this->why_eltaher_first_title_ar : $this->{'why_eltaher_first_title_' . App::getLocale()};
    }

    public function getWhyEltaherFirstDescAttribute()
    {
        return $this->{'why_eltaher_first_desc_' . App::getLocale()} == null ? $this->why_eltaher_first_desc_ar : $this->{'why_eltaher_first_desc_' . App::getLocale()};
    }

    public function getWhyEltaherSecondTitleAttribute()
    {
        return $this->{'why_eltaher_second_title_' . App::getLocale()} == null ? $this->why_eltaher_second_title_ar : $this->{'why_eltaher_second_title_' . App::getLocale()};
    }

    public function getWhyEltaherSecondDescAttribute()
    {
        return $this->{'why_eltaher_second_desc_' . App::getLocale()} == null ? $this->why_eltaher_second_desc_ar : $this->{'why_eltaher_second_desc_' . App::getLocale()};
    }

    public function getReserveExamDescAttribute()
    {
        return $this->{'reserve_exam_desc_' . App::getLocale()} == null ? $this->reserve_exam_desc_ar : $this->{'reserve_exam_desc_' . App::getLocale()};
    }

    public function getFooterDescAttribute()
    {
        return $this->{'footer_desc_' . App::getLocale()} == null ? $this->footer_desc_ar : $this->{'footer_desc_' . App::getLocale()};
    }

    public function getAddressAttribute()
    {
        return $this->{'address_' . App::getLocale()} == null ? $this->address_ar : $this->{'address_' . App::getLocale()};
    }

    public function getExamHeaderDescriptionAttribute()
    {
        return $this->{'exam_header_description_' . App::getLocale()} == null ? $this->exam_header_description_ar : $this->{'exam_header_description_' . App::getLocale()};
    }
}
