<?php

namespace App\Sys\Repositories\Packages;

use App\Models\Subscription;

class SubscriptionRepository
{
    public function getLatestSubscriptionByUserId($userId)
    {
        return Subscription::with('package')
            ->where('user_id', $userId)
            ->where('expiration_date', '>=', now())
            ->latest('subscription_date')
            ->first();
    }
}
