<?php

namespace App\Sys\Repositories\Questions;

use App\Models\FavoriteQuestion;

class FavoriteQuestionRepository
{
    public function addFavorite($userId, $data)
    {
        $favoriteQuestion = new FavoriteQuestion();
        $favoriteQuestion->user_id = $userId;
        $favoriteQuestion->question_id = $data['question_id'];
        return $favoriteQuestion->save();
    }

    public function removeFavorite($data)
    {
        return FavoriteQuestion::findOrFail($data['favorite_id'])->delete();
    }

    public function getFavoriteQuestions($limit, $userId)
    {
        return FavoriteQuestion::where('user_id', $userId)
            ->with('question')
            ->paginate($limit);
    }

    public function getSelectedFavoriteQuestion($userId, $favoriteId)
    {
        return FavoriteQuestion::where('user_id', $userId)
            ->where('id', $favoriteId)
            ->with('question')->first();
    }
}
