<?php

namespace App\Sys\Repositories\Theories;

use App\Models\TheoryPackage;

class TheoryPackageRepository
{
    public function getPaginatedTheories($limit)
    {
        return TheoryPackage::query()
            ->where('enable', 1)
            ->latest()
            ->paginate($limit);
    }

    public function getSelectedTheory($theoryId)
    {
        return TheoryPackage::query()
            ->where('enable', 1)
            ->find($theoryId);
    }
}
